<?php session_start(); ?>
<?php
require './includes/classEvalSecure.php';
require './includes/classEvaluateDB.php';
require './includes/classSiem.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());
$SIEM = new devt\siem\siem($devt_environment->getkey("SIEMHOST"));

$dir = $devt_environment->getkey('BACKUPDIR');

function var_error_log( $object=null )
{
    ob_start();                    // start buffer capture
    var_dump( $object );           // dump the values
    $contents = ob_get_contents(); // put the buffer into a variable
    ob_end_clean();                // end capture
    error_log( $contents );        // log contents of the result of var_dump( $object )
}


$global = $DB->getGlobal();
ESecure::CheckPage(SECURITY_COMMANDER);
$user = $DB->getUser($_SESSION['userid']);
ESecure::CheckUser($user);

$instancename = $devt_environment->getkey("DATABASE_NAME");

if ($_SERVER["REQUEST_METHOD"] == "POST")
{
    if (!Secure::checkCSRF())
    {
        $SIEM->createSecurityEntry("csrf",SECUITY_INVALID_CSRF,"minor",getenv("VAULT_SHELF"),"Invalid CSRF in Purge Everything");
        $DB->createSecurityAudit($user, __FILE__ . "[".__LINE__."] Failed CSRF check");
        header("Location: SecurityError.php");
        exit();
    }

    if (isset($_POST['purge']) )
    {
        $result = $DB->Backup($user,$dir);
        if ($result['status'] == 0)
        {
           $DB->deleteAllButFirstUser();
        }
    }
    $_SESSION['nextStep'] = 1;
    header('Location: Maintenance.php');
    exit();
}


?>
<!DOCTYPE HTML>
<html>
<head>
<meta name="viewport" content="width=device-width" />
<meta name="viewport" content="initial-scale=1.0" />
<link href="css/Base.css" rel="stylesheet">
<style>
#container {margin: auto;}
#main {margin: 20px;border: solid 1px #779;padding: 10px;border-radius: 6px;background-color: #ffe;}
#main h2 {font-family: 'Roboto', sans-serif;color: red; text-align: center;font-size: 16pt;}
input {font-size: 14pt;}
</style>
</head>
<body>
    <div id='container'>
        <div id='heading'>
            <table>
                <tr><td></td><td class='ht'>nVALUATE</td><td></td></tr>
            </table>
        </div>
        <div id='main'>
            <h2>WARNING ** THIS WILL COMPLETEY WIPE EVERYTHING YOU HAVE ** </h2>
            <h2>HIGHLY RECOMMEND THAT YOU MAKE A <a href='Maintenance.php?prog=2'>BACKUP</a> FIRST</h2>
            <form method="post" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>">
                <input type='submit' value='PURGE ALL' name='purge' />
                <?php echo "<input type='hidden' name='formtoken' value='{$_SESSION['csrf_key']}' />";?>
            </form>
        </div>
    </div>
</body>
</html>