<?php session_start(); ?>
<?php
require './includes/classEvalSecure.php';
require './includes/classEvaluateDB.php';
require './includes/classTime.php';
require './includes/EvaluatorTimeLine.php';

$DB = new EvaluateDB($devt_environment->getDatabaseParameters());

$selff = htmlspecialchars($_SERVER["PHP_SELF"]);
$instancename = $devt_environment->getkey("DATABASE_NAME");

$_SESSION['returnto'] = $selff;

$global = $DB->getGlobal();
ESecure::CheckPage(SECURITY_ADMIN);
$user = $DB->getUser($_SESSION['userid']);
ESecure::CheckUser($user);


function var_error_log( $object=null ,$text='')
{
    ob_start();                    // start buffer capture
    var_dump( $object );           // dump the values
    $contents = ob_get_contents(); // put the buffer into a variable
    ob_end_clean();                // end capture
    error_log( "{$text} {$contents}" );        // log contents of the result of var_dump( $object )
}

function var_debug_dump($object=null ,$text='')
{
    ob_start();                    // start buffer capture
    var_dump( $object );           // dump the values
    $contents = ob_get_contents(); // put the buffer into a variable
    ob_end_clean();                // end capture
    $f = fopen("/var/dumps/debugdump.txt","a");
    fwrite($f,$text . "\n");
    fwrite($f,$contents ."\n");
    fclose($f);
}

function createProgress($percent)
{
    if ($percent == 100.0)
        $c = "#39dc89";
    else
        $c = "var(--nvaluate-lightorange)";
    echo "<div class='progressbar'>";
    echo "<div class='innerbar' style='width: {$percent}%; background-color: {$c};'>";
        echo "</div>";
    echo "</div>";
}
//Start
$evaluation = null;
$numEnbaledPhases = 0;


if (isset($_SESSION['current_evaluation']) && $_SESSION['current_evaluation'] != 0)
    $evaluation = $DB->getEvaluation($_SESSION['current_evaluation']);
else
{
    //If we have only one evluation let set that one
    if (1 == $DB->numOfEvaluations())
    {
        $evaluation = $DB->getFirstEvaluation();
        $_SESSION['current_evaluation'] = $evaluation['idevaluation'];
    }
}

if (!$evaluation)
{
    header("Location: ChooseEval.php");
    exit();
}

$results = array();
$r = $DB->allPhasesForEval($evaluation['idevaluation'],"order by phase_order");
while ($phase = $r->fetch_array(MYSQLI_ASSOC))
{
    $results[$phase['idphase']] = $DB->getProgress($evaluation['idevaluation'],$phase['idphase']);
    $results[$phase['idphase']] ['phase_name'] = $phase['phase_name'];
    $results[$phase['idphase']] ['status'] = $phase['phase_status'];
}

$r = $DB->allPhasesForEvalEnabled($evaluation['idevaluation']);
$numEnbaledPhases = $r->num_rows;
$currentPhaseName="";
$currentTeamName="";

$alltimes = EvaluatorTimeLines($DB,$evaluation['idevaluation']);

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta name="viewport" content="width=device-width" />
    <meta name="viewport" content="initial-scale=1.0" />
    <title>PROGRESS</title>
    <link id="myicon" rel="icon" type="image/png" href="images/Icon1.png" />
    <link href="css/Colours.css" rel="stylesheet" />
    <link href="css/Base.css" rel="stylesheet">
    <link href="css/Progress.css" rel="stylesheet" />
    <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
    <script>
        var g_names = {
                <?php
            $r = $DB->allEvaluators();
            while ($evaltrs = $r->fetch_assoc())
            {
                $name = htmlspecialchars(stripslashes($evaltrs['user_name']));
                echo "'{$evaltrs['iduser']}':'{$name}',";
            }
        ?>
        };
        var g_phases = [
        <?php
        foreach($results as $phaseid => $result)
        {
            if ($result['status'] == "enabled")
                echo "{$phaseid},";
        }
        ?>
        ];
        //{ 'phaseid': {'userid':[t1,t2,t3]}}
        var g_chartdata = {
                <?php
                foreach($results as $phaseid => $result)
                {
                    if ($result['status'] == "enabled")
                    {
                        echo "'{$phaseid}': {";

                        $r = $DB->allEvaluators("order by user_name");
                        while ($evaluator = $r->fetch_assoc())
                        {
                            if ($DB->userHasPhase($evaluator['iduser'],$phaseid) )
                            {
                                if (isset($alltimes[$evaluator['iduser']] [$phaseid]) )
                                {
                                    $data = $alltimes[$evaluator['iduser']] [$phaseid];
                                    echo "'{$evaluator['iduser']}': [";
                                    $cnt = $data['count'];
                                    $times = $data['times'];
                                    $tcnt = 0;
                                    $counttimes = count($times);
                                    foreach ($times as $time)
                                    {
                                        if ($time)
                                        {
                                            $tcnt++;
                                            $v = floatval($tcnt)/floatval($cnt);
                                            echo "[";
                                            $nt = new DateTime($time);
                                            $nt->setTimezone(new DateTimeZone($user['user_timezone']));
                                            $dete = $nt->format('Y') . "," . strval(intval($nt->format('m')) -1) . "," . $nt->format('d') . "," . $nt->format('H') ."," . $nt->format('i') . "," . $nt->format('s');
                                            $strt = "new Date({$dete})";
                                            echo "{$strt},{$v}";
                                            echo "],";
                                        }
                                    }
                                    echo "],";
                                }
                            }
                        }
                        echo "},";
                    }
                }
        ?>
        };

        google.charts.load('current', { 'packages': ['corechart'] });

        function pad(num, size)
        {
            var s = num+"";
            while (s.length < size) s = "0" + s;
            return s;
        }


        function drawPhase(phase) {

            var phasedata = g_chartdata[phase];
            var evaluators = Object.keys(phasedata);

            var alldata = [];
            var heading = [];
            var numE = 0;
            heading[0] = { label: "Time", type: "date" };
            for (var i = 0; i < evaluators.length; i++) {
                var pd = phasedata[evaluators[i]];
                if (pd.length > 0) {
                    heading[i + 1] = g_names[evaluators[i]];
                    numE++;
                }
            }
            alldata.push(heading);
            var idx = 0;
            for (var i = 0; i < evaluators.length; i++) {
                var pdata = phasedata[evaluators[i]];
                
                if (pdata.length > 0) {
                    idx++;
                    for (var j = 0; j < pdata.length; j++) {
                        var entity = [];
                        for (var k = 0; k < numE; k++) {
                            entity[k + 1] = null;
                        }
                        entity[0] = pdata[j][0];
                        entity[idx] = pdata[j][1] * 100;
                        alldata.push(entity);
                    }
                }
            }

            if (alldata.length > 1) {
                var data = google.visualization.arrayToDataTable(alldata);

                var options = {
                    title: 'Progress',
                    curveType: 'function',
                    height: 500,
                    width: 800,
                    chartArea:{left:60,top:40,width:'90%',height:'80%'},
                    backgroundColor: '#ffffff',
                    titleTextStyle: { color: '#b0b0ff' },
                    vAxis: { title: 'Percent Complete',textStyle: { color: '#606060' }, maxValue: 100, minValue: 0 },
                    hAxis: { textStyle: { color: '#606060' } },
                    legend: { position: 'bottom', textStyle: { color: '#505050', fontSize: 10 } }
                };

                var chart = new google.visualization.LineChart(document.getElementById('chart' + pad(phase, 4)));
                chart.draw(data, options);
            }
            else {
                var c = document.getElementById('chart' + pad(phase, 4)); 
                c.innerHTML = "<p>NO DATA</p>";
                c.innerHTML += "<p>Note: If scores have been copied from a prior phase, no direct evaluator input has been recorded.</p>";
            }
        }

        function drawAllBarcodes() {
            var l = document.getElementsByClassName('_barcode');
            for (var i = 0; i < l.length; i++) {
                var percent = parseFloat(l[i].getAttribute('_percent'));
                var c = "var(--nvaluate-lightorange)";
                if (percent == 100.0)
                    c = "#39dc89";
                var d1 = document.createElement("DIV");
                d1.className = "progressbar";
                var d2 = document.createElement("DIV");
                d2.className = "innerbar";
                d2.style.width = percent + "%";
                d2.style.backgroundColor = c;
                d1.appendChild(d2);
                l[i].appendChild(d1);
            }
        }

        function drawAllCharts() {
            for (var i = 0; i < g_phases.length; i++)
                drawPhase(g_phases[i]);
        }

        function start() {
            drawAllBarcodes();
            drawAllCharts();
        }
    </script>
</head>
<body onload="start()">
  <div class="container">
    <div id='heading'>
        <table>
            <tr><td></td><td class='ht'>nVALUATE</td><td></td></tr>
        </table>
    </div>
    <div id='menu'>
        <div class='d1'><a href='Admin.php'>ADMIN</a></div>
        <div class='d1'><a href="Signout.php">SIGN OUT</a></div>
        <?php
        if (ESecure::IS_MODULE_SCORE() && Secure::CheckSecurity(SECURITY_EVALUATE))
            echo "<div class='d1'><a href='Score'>SCORE</a></div>";
        ?>
        <?php
        if (ESecure::IS_MODULE_ROOM())
                echo "<div class='d1'><a href='DataRoom.php'>DATAROOM</a></div>";
        ?>
        <div class='d2'><?php if ($user) echo $user['user_name'];?></div>
        <div class='clear'></div>
    </div>
    <div id='main'>
        <?php
        $displayedHeading = false;
        echo "<div id='summary'>";
            echo "<div id='phasesummary'>";
            echo "<h1>PHASE SUMMARY</h1>";
                echo "<div id='table2'>";
                    echo "<table>";
                    foreach($results as $result)
                    {
                        $strName = htmlspecialchars(stripslashes($result['phase_name']));
                        $strStatus = "";
                        switch($result['status'])
                        {
                            case "defined":
                                $strStatus = "Not Started";
                                break;
                            case "enabled":
                                $strStatus = "In Progress";
                                break;
                            case "complete":
                                $strStatus = "Completed";
                                break;
                        }

                        $teams = $result['teams'];
                        $sumAnswered = 0;
                        $sumScores = 0;
                        foreach ($teams as $team)
                        {
                            $totals = $team['totals'];
                            $sumAnswered += $totals['totanswered'];
                            $sumScores += $totals['totscores'];
                        }

                        $strperc = 0.0;
                        if ($sumScores > 0)
                        {
                            $perc = (floatval($sumAnswered) * 100.0) / floatval($sumScores);
                            $strperc = sprintf("%4.1f%%",$perc);
                        }

                        if ($sumScores > 0)
                            $percprog = ($sumAnswered/$sumScores)*100.0;
                        else
                            $percprog = 0.0;
                        echo "<tr><td>{$strName}</td><td>{$strStatus}</td><td><div class='_barcode' _percent='{$percprog}'></div></td>";

                        echo "<td class='r'>{$strperc}</td></tr>";
                    }
                    echo "</table>";
                echo "</div>";
            echo "</div>";
        echo "</div>";
        echo "<hr/>";
        if ($numEnbaledPhases > 0)
        {

            echo "<div id='inprogress'>";
            echo "<div id='inprogresshd'>";
            echo "<h1>IN PROGRESS PHASES</h1>";
            echo "</div>";
            echo "<div id='chart1'>";

            echo "</div>";
            echo "<div id='table1'>";
            echo "<table>";
            foreach($results as $phaseid => $result)
            {
                if (! $displayedHeading)
                {
                    echo "<tr><th colspan='9'>PHASE</th></tr>";
                    echo "<tr><th></th><th colspan='4'>TEAM</th><th class='c'colspan='2' >SCORE ENTRY TIMESTAMPS</th><th>RATE</th><th class='r'>ESTIMATED DURATION</th><th class='r'>ESTIMATED TIME OF</th></tr>";
                    echo "<tr><th colspan='2' class='lh'></th><th class='lh'>EVALUATOR</th><th class='lh'>PROGRESS</th><th class='lh'></th><th class='c lh'>FIRST SCORE</th><th class='c lh'>LAST SCORE</th><th class='lh'>PER DAY</th><th class='r lh'>TO COMPLETE</th><th class='r lh'>COMPLETION</th></tr>";
                    $displayedHeading = true;
                }

                if ($result['status'] == "enabled")
                {
                    $teams = $result['teams'];
                    if ($currentPhaseName != $result['phase_name'])
                    {
                        $strName = htmlspecialchars(stripslashes($result['phase_name']));

                        $currentPhaseName = $result['phase_name'];
                        $currentTeamName = "";

                        //Totals for phase
                        $sumAnswered = 0;
                        $sumScores = 0;

                        foreach ($teams as $team)
                        {
                            $totals = $team['totals'];
                            $sumAnswered += $totals['totanswered'];
                            $sumScores += $totals['totscores'];
                        }
                        if (floatval($sumScores) > 0.0)
                            $perc = (floatval($sumAnswered) * 100.0) / floatval($sumScores);
                        else
                            $perc = 0;
                        $strperc = sprintf("%4.1f%%",$perc);

                        echo "<tr><td colspan='3' class='phase'>{$strName}</td><td></td><td class='r'>{$strperc}</td></tr>";

                    }


                    foreach ($teams as $team)
                    {
                        if ($currentTeamName != $team['name'])
                        {
                            $strName = htmlspecialchars(stripslashes($team['name']));
                            $currentTeamName = $team['name'];
                            echo "<tr><td></td><td colspan='8' class='team'>{$strName}</td></tr>";
                        }

                        if (count($team['users']) > 0)
                        {
                            $t = intval($team['totals']['totscoresperevaluator']);
                            $usrs = $team['users'];
                            foreach ($usrs as $us)
                            {
                                $strName = htmlspecialchars(stripslashes($us['name']));
                                $c = intval($us['scored']);
                                $strPerc = "0.0%";
                                if ($t > 0)
                                    $strPerc = sprintf("%3.1f%%", 100.0 * $c/$t);

                                $auditFirst = $DB->FirstScoreAuditForUserForPhaseForTeam($evaluation['idevaluation'],intval($us['id']),$phaseid,intval($team['id']));
                                $auditLast = $DB->LastScoreAuditForUserForPhaseForTeam($evaluation['idevaluation'],intval($us['id']),$phaseid,intval($team['id']));
                                $strTimeFirst = "";
                                $strTimeLast = "";
                                $elapsed = 0;
                                $rate = 0;
                                $strRatePerday="";
                                $etc="";
                                $etcel="";
                                if ($auditFirst)
                                {
                                    $strTimeFirst = classTimeHelpers::smartTime($auditFirst['audit_timestamp'],$user['user_timezone']);

                                }
                                if ($auditLast)
                                {
                                    $strTimeLast = classTimeHelpers::smartTime($auditLast['audit_timestamp'],$user['user_timezone']);
                                }
                                if ($auditFirst)
                                {
                                    //Calculate rate
                                    if ($c == $t)
                                        $elapsed = (new DateTime($auditLast['audit_timestamp']))->getTimestamp() - (new DateTime($auditFirst['audit_timestamp']))->getTimestamp();
                                    else
                                        $elapsed = (new DateTime('now'))->getTimestamp() - (new DateTime($auditFirst['audit_timestamp']))->getTimestamp();
                                    $rate = $c/$elapsed;  //rate per second
                                    $rateperDay = $rate * 3600 * 24;
                                    $strRatePerday = sprintf("%3.1f",$rateperDay);

                                    if ($c != $t)
                                    {
                                        $dtFinish = (new DateTime())->setTimestamp((new DateTime('now'))->getTimestamp() + ($t-$c)/$rate);
                                        $etc = classTimeHelpers::smartTime($dtFinish,$user['user_timezone']);
                                        $etcel = classTimeHelpers::smartTimeDiff($dtFinish);
                                    }
                                }
                                if ($c == 0)
                                    echo "<tr class='notstarted'>";
                                else
                                    echo "<tr>";
                                $progressclass = "";
                                if ($c == $t)
                                    $progressclass = "completed";
                                //echo "<td></td><td></td><td>{$strName}</td><td><progress class='{$progressclass}' value='{$c}' max='{$t}'></progress></td><td class='r'>{$strPerc}</td><td  class='r'>{$strTimeFirst}</td><td class='r'>{$strTimeLast}</td><td class='r'>{$strRatePerday}</td><td class='r'>{$etcel}</td><td class='r'>{$etc}</td></tr>";
                                echo "<td></td><td></td><td>{$strName}</td>";

                                $barPercent = ($c/$t)*100.0;
                                echo "<td><div class='_barcode' _percent='{$barPercent}'></div></td></td>";

                                echo "<td class='r'>{$strPerc}</td><td  class='r'>{$strTimeFirst}</td><td class='r'>{$strTimeLast}</td><td class='r'>{$strRatePerday}</td><td class='r'>{$etcel}</td><td class='r'>{$etc}</td></tr>";
                            }
                        }
                    }
                }
            }
            echo "</table>";
            echo "</div>";
            echo "<hr />";
            echo "<div id='teamcarts'>";
            echo "<h1>IN PROGRESS EVALUATOR SCORING CHARTS</h1>";
            echo "<p>The following charts provide a record of an evaluators scoring over time.</p>";
            foreach($results as $phaseid => $result)
            {
                $phase = $DB->getPhase($phaseid);


                if ($result['status'] == "enabled")
                {
                    $strName = htmlspecialchars(stripslashes($result['phase_name']));
                    echo "<h2>PHASE {$strName}</h2>";

                    if ($phase['phase_populate_from_utility'])
                    {
                        $u1 = $DB->getUser($phase['phase_populate_user']);

                        echo "<p class='note'>NOTE: This phase has scores pre-populated from another phase via the utility ";
                        if ($u1)
                        {
                            $strPerson = htmlspecialchars(stripslashes($u1['user_name']));
                            echo "by {$strPerson} on ";
                        }
                        else
                            echo "on ";
                        echo classTimeHelpers::timeFormatnthDate($phase['phase_last_populate'],$user['user_timezone']);
                        echo "</p>";
                        echo "<p class='note'>The following graphs only indicate evaluator changes, and therefore may not equal total scores for phase.</p>";
                    }

                    $strName = htmlspecialchars(stripslashes($team['name']));
                    $strChartId = sprintf("%04d",intval($phaseid));
                    echo "<div class='chartcontainer'>";
                    echo "<div id='chart{$strChartId}'>";
                    echo "</div>";
                    echo "</div>";
                }
            }
            echo "</div>";
            echo "</div>";
        }
        
        ?>
    </div>
  </div>
</body>
</html>
