<?php session_start(); ?>
<?php
require './includes/classEnvironment.php';

header('Content-type: text/csv');
require './includes/Security.php';

require './includes/classEvaluateDB.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());

if (!isSignedIn())
{
    //Check cookie
    $UserOK = false;
    if (isset($_COOKIE['SITEINFO']))
    {
        $user = $DB->getUserByCookie($_COOKIE['SITEINFO']);
        if ($user)
        {
            SetSessionData($user);
            $UserOK = true;
        }
    }
    if (!$UserOK)
        SigninAndRedirect();
}

if (!CheckSecurity(SECURITY_ADMIN) )
{
    header("Location: SecurityError.php");
    exit();
}
$evaluation = null;
//Check that we have an evaluatio set.
if (!isset($_SESSION['current_evaluation']) && $_SESSION['current_evaluation'] != 0)
{
    echo "No evaluation set";
    exit();
}
else
    $evaluation = $DB->getEvaluation($_SESSION['current_evaluation']);

$teamid = 0;
$phaseid = 0;
$user = $DB->getUser($_SESSION['userid']);

if (isset($_GET['team'])) $teamid = intval($_GET['team']);
if (isset($_GET['phase'])) $phaseid = intval($_GET['phase']);

if ($teamid == 0 || $phaseid == 0)
{
    echo "No phase or team specified";
    exit();
}

$team = $DB->getTeam($teamid);

function scoresForQuestionSub($teamid,$phaseid,$question,$sub)
{
    global $DB;
    global $evaluation;

    $scoreType = $question['question_type'];

    $strQ = htmlspecialchars($question['question_identifier'],ENT_QUOTES | ENT_HTML401);
    echo $strQ . ",";
    if ($sub)
    {
        $scoreType = $question['subattribute_type'];
        echo $sub['subattribute_number'] . ",";
    }
    else
        echo ",";

    $done_one = false;
    $r = $DB->allRespondentsForEval($evaluation['idevaluation'], 'order by respondent_name_short');
    while ($respondent = $r->fetch_array(MYSQLI_ASSOC) )
    {
        $sum = 0;
        $max = 0;
        $min = 0;
        $cnt = 0;
        $bOne = false;
        $r1 = $DB->allUsersForTeam($teamid);
        while ($user = $r1->fetch_array(MYSQLI_ASSOC))
        {
            $score = null;
            if ($sub)
                $score = $DB->getScoreDetail($user['iduser'],$evaluation['idevaluation'],$phaseid,$respondent['idrespondent'],$question['idquestion'],$sub['idsubattribute']);
            else
                $score = $DB->getScoreDetail($user['iduser'],$evaluation['idevaluation'],$phaseid,$respondent['idrespondent'],$question['idquestion'],null);
            if ($score && isset($score['score_score']))
            {
                switch ($scoreType)
                {
                    case 'range':
                        echo $score['score_score'] . ",";
                        break;
                    case 'boolean':
                        if (intval($score['score_score']) > 0)
                            echo "YES,";
                        else
                            echo "NO,";
                        break;
                    default:
                        echo $score['score_score'] . ",";
                        break;
                }

                $v = intval($score['score_score']);
                $sum += $v;
                if (!$bOne)
                {
                    $max = $v;
                    $min = $v;
                }
                if ($v > $max) $max = $v;
                if ($v < $min) $min = $v;
                $cnt ++;
                $bOne = true;
            }
            else
                echo ",";
        }
        echo $min . ",";
        echo $max . ",";
        if ($cnt > 0)
            $avg = intval($sum / $cnt);
        else
            $avg = 0;
        echo $avg . ",";
        $dif = $max-$min;
        echo $dif;
        echo ",";
    }
    echo "\r\n";
}

    //Build headers
    //Need to know how many users are allocated to this team
    echo "Evaluation title: ";
    echo $DB->displayText($evaluation['evaluation_name']);
    echo "\r\n";

    echo $DB->displayText($team['team_name']);
    echo "\r\n";

    $dt = new DateTime();
    $dt->setTimezone(new DateTimeZone($user['user_timezone']));
    $str = $dt->format('D jS M Y H:i');
    echo "Extract Date {$str}\r\n";

    $num_users = $DB->numUsersForTeam($teamid);
    $done_one = false;

    echo ",,";
    $r = $DB->allRespondentsForEval($evaluation['idevaluation'], 'order by respondent_name_short');
    while ($respondent = $r->fetch_array(MYSQLI_ASSOC))
    {
        if ($done_one)
        {
            echo ",";
            $done_one = true;
        }
        echo $respondent['respondent_name_short'];
        for ($i = 0; $i < ($num_users + 4); $i++)
            echo ",";
    }
    echo "\r\n";

    $done_one = false;
    echo "Question,Sub Attribute,";
    $r = $DB->allRespondentsForEval($evaluation['idevaluation'], 'order by respondent_name_short');
    while ($respondent = $r->fetch_array(MYSQLI_ASSOC))
    {
        $r1 = $DB->allUsersForTeam($teamid);
        while ($user = $r1->fetch_array(MYSQLI_ASSOC))
        {
            echo $user['user_name'] .",";
        }
        echo "Min,Max,Avg,Diff,";
    }
    echo "\r\n";


    $r = $DB->allQuestionsForTeam($teamid);
    while ($question = $r->fetch_array(MYSQLI_ASSOC))
    {
        $r1 = $DB->allSubForQuestion($question['idquestion'],'order by subattribute_number');
        if ($r1->num_rows == 0)
        {
            scoresForQuestionSub($teamid,$phaseid,$question,null);
        }
        else
        {
            while ($sub = $r1->fetch_array(MYSQLI_ASSOC))
            {
                scoresForQuestionSub($teamid,$phaseid,$question,$sub);
            }
        }
    }
?>    
