<?php session_start(); ?>
<?php
require './includes/classEvalSecure.php';
require './includes/classEvaluateDB.php';
require './includes/classFormList.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());

$selff = htmlspecialchars($_SERVER["PHP_SELF"]);

$global = $DB->getGlobal();
ESecure::CheckPage(SECURITY_ADMIN);
$user = $DB->getUser($_SESSION['userid']);
ESecure::CheckUser($user);

function var_error_log( $object=null ,$text='')
{
    ob_start();                    // start buffer capture
    var_dump( $object );           // dump the values
    $contents = ob_get_contents(); // put the buffer into a variable
    ob_end_clean();                // end capture
    error_log( "{$text} {$contents}" );        // log contents of the result of var_dump( $object )
}

function groomHTML($h)
{
    $t = trim($h);
    if (substr($t,0,1) != "<")
        return $t;
    $t = stripslashes($t);
    $t = htmlspecialchars_decode($t);
    $t = strip_tags($t, ['p', 'ul' , 'ol' ,'li' ,'h1' ,'h2']);
    $ret = "";
    while (strpos($t,"<") !== false)
    {
        $ret .= substr($t,0,1);
        $t = substr($t,1);
        $t = trim($t);
        $tok = strtok($t,">");
        $ret .= strtok($tok," ") . ">";
        $t = strstr($t,">");
        $t = substr($t,1);
        if (substr($t,0,1) != "<")
        {
            $ret .= strtok($t,"<");
            $t = substr($t,strpos($t,"<"));
        }
    }
    return $ret;
}

$berr = false;
$errortext = '';
$user = null;
$evaluation = null;


if (!isset($_SESSION['current_evaluation']) && $_SESSION['current_evaluation'] != 0)
{
    header('Location: SetEval.php');
    exit();
}
else
    $evaluation = $DB->getEvaluation($_SESSION['current_evaluation']);


if ($_SERVER["REQUEST_METHOD"] == "POST")
{
    $fields = array();
    $section = null;
    $question = null;
    $section_num = 0;

    $textonly = FormList::getCheckBoxField("textonly");

    $good_file = false;
    if (isset($_FILES['files']))
    {
        if (isset($_FILES['files'] ['tmp_name']) && strlen($_FILES['files'] ['tmp_name']) > 0)
            $good_file = true;
    }

    if (!$good_file)
    {
        $errortext = "No file specified";
        $_SESSION['loaderror'] = $errortext;
        header("Location: {$_SESSION['returnto']}");
        exit();
    }

    if (!$textonly)
        $DB->purgeEvaluation($evaluation['idevaluation']);

    if (($f = fopen($_FILES['files'] ['tmp_name'], "r")) !== FALSE)
    {
        while (($row = fgetcsv($f, 0, ",")) !== FALSE)
        {
            if (empty($fields))
            {
                $fields = $row;
                //Remove funny charaters
                for($idx =0;$idx < count($fields);$idx++)
                {
                    $fields[$idx] = str_replace("\xef","",$fields[$idx]);
                    $fields[$idx] = str_replace("\xbb","",$fields[$idx]);
                    $fields[$idx] = str_replace("\xbf","",$fields[$idx]);
                    $fields[$idx] = strtoupper($fields[$idx]);
                }


                //Check that we have all the mandatory fields
                if ( !in_array("SECTION",$fields) || ! in_array("QUESTION",$fields)  || ! in_array("WEIGHTING",$fields)  || ! in_array("TEXT",$fields)  )
                {
                    $errortext .= "The input file MUST have a SECTION,QUESTION,WEIGHTING and TEXT column";
                    header("Location: {$_SESSION['returnto']}");
                    exit();
                }
                continue;
            }

            $data = array();
            foreach ($row as $k=>$value)
            {
                $data[strtoupper($fields[$k])] = $value;
            }

            if (array_key_exists('SECTION',$data) && $data['SECTION'] && strlen($data['SECTION']) > 0)
            {
                if (!$textonly)
                {
                    if (!$DB->getSectionByName($evaluation['idevaluation'],$data['SECTION']) )
                    {
                        $section_num++;
                        $DB->createSection($evaluation['idevaluation'],$section_num,$data['SECTION']);
                        $section = $DB->getSectionByName($evaluation['idevaluation'],$data['SECTION']);
                    }
                }
            }

            if (array_key_exists('QUESTION',$data) && $data['QUESTION'] && strlen($data['QUESTION']) > 0)
            {
                $question = $DB->getQuestionByNum($evaluation['idevaluation'],$data['QUESTION']);
                if (!$question && !$textonly)
                {
                    $w = 0.0;
                    $question_num = 0;
                    $txt = '';
                    $guide = '';
                    $tag = '';
                    $question_num = $data['QUESTION'];
                    if (array_key_exists('WEIGHTING',$data) && $data['WEIGHTING'] && strlen($data['WEIGHTING']) > 0)
                        $w = $data['WEIGHTING'];
                    if (array_key_exists('TEXT',$data) && $data['TEXT'] && strlen($data['TEXT']) > 0)
                        $txt = $data['TEXT'];
                    if (array_key_exists('SUBATTRIBUTE',$data) && $data['SUBATTRIBUTE'] && strlen($data['SUBATTRIBUTE']) > 0)
                        $guide = '';
                    else
                    {
                        if (array_key_exists('GUIDE',$data) && $data['GUIDE'] && strlen($data['GUIDE']) > 0)
                            $guide = $data['GUIDE'];
                    }
                    if (array_key_exists('TAG',$data) && $data['TAG'] && strlen($data['TAG']) > 0)
                    {
                        $tag = $data['TAG'];
                        if (strlen($tag) > 10)
                            $tag = substr($tag,0,10);
                    }

                    //Entry type
                    $type = 'range';
                    if (array_key_exists('TYPE',$data) && $data['TYPE'] && strlen($data['TYPE']) > 0)
                    {
                        $entry_type = strtoupper(trim($data['TYPE']));
                        if ($entry_type == "YESNO" || $entry_type = "BOOLEAN" || $entry_type == "TRUEFALSE")
                            $type = "boolean";
                    }

                    $txt = str_replace("\x92","\'",$txt);
                    $guide = str_replace("\x92","\'",$guide);

                    $txt = groomHTML($txt);
                    $guide = groomHTML($guide);
                    $DB->createQuestion($evaluation['idevaluation'],$section['idsection'],$question_num,$txt,$w,$guide,$tag,$type);
                    $question = $DB->getQuestionByNum($evaluation['idevaluation'],$question_num);
                }
                else
                    if ($textonly)
                    {
                        $txt = '';
                        if (array_key_exists('TEXT',$data) && $data['TEXT'] && strlen($data['TEXT']) > 0)
                            $txt = $data['TEXT'];
                        if (array_key_exists('SUBATTRIBUTE',$data) && $data['SUBATTRIBUTE'] && strlen($data['SUBATTRIBUTE']) > 0)
                            $guide = '';
                        else
                        {
                            if (array_key_exists('GUIDE',$data) && $data['GUIDE'] && strlen($data['GUIDE']) > 0)
                                $guide = $data['GUIDE'];
                        }

                        $txt = str_replace("\x92","\'",$txt);
                        $guide = str_replace("\x92","\'",$guide);

                        $txt = groomHTML($txt);
                        $guide = groomHTML($guide);
                        $DB->updateQuestion($question['idquestion'],$txt,$guide);
                        $question = $DB->getQuestionByNum($evaluation['idevaluation'],$question['question_identifier']);
                    }
            }
            if (array_key_exists('SUBATTRIBUTE',$data) && $data['SUBATTRIBUTE'] && strlen($data['SUBATTRIBUTE']) > 0)
            {

                $suba = $DB->getSubByNum($question['idquestion'],$data['SUBATTRIBUTE']);
                if (!$suba && !$textonly)
                {
                    $txt = '';
                    $guide = '';
                    $w2 = '';
                    if (array_key_exists('SUB_WEIGHTING',$data) && $data['SUB_WEIGHTING'] && strlen($data['SUB_WEIGHTING']) > 0)
                        $w2 = $data['SUB_WEIGHTING'];
                    if (array_key_exists('SUB_TEXT',$data) && $data['SUB_TEXT'] && strlen($data['SUB_TEXT']) > 0)
                        $txt = $data['SUB_TEXT'];
                    if (array_key_exists('GUIDE',$data) && $data['GUIDE'] && strlen($data['GUIDE']) > 0)
                        $guide = $data['GUIDE'];

                    $txt = str_replace("\x92","\'",$txt);
                    $guide = str_replace("\x92","\'",$guide);


                    $txt = groomHTML($txt);
                    $guide = groomHTML($guide);

                    //Entry type
                    $type = 'range';
                    if (array_key_exists('TYPE',$data) && $data['TYPE'] && strlen($data['TYPE']) > 0)
                    {
                        $entry_type = strtoupper(trim($data['TYPE']));
                        if ($entry_type == "YESNO" || $entry_type = "BOOLEAN" || $entry_type == "TRUEFALSE")
                            $type = "boolean";
                    }

                    $DB->createSubAttribute($question['idquestion'],$data['SUBATTRIBUTE'],$txt,$guide,$w2,$type);
                }
                else
                if ($textonly)
                {
                    $txt = '';
                    $guide = '';
                    $w2 = '';
                    if (array_key_exists('SUB_WEIGHTING',$data) && $data['SUB_WEIGHTING'] && strlen($data['SUB_WEIGHTING']) > 0)
                        $w2 = $data['SUB_WEIGHTING'];
                    if (array_key_exists('SUB_TEXT',$data) && $data['SUB_TEXT'] && strlen($data['SUB_TEXT']) > 0)
                        $txt = $data['SUB_TEXT'];
                    if (array_key_exists('GUIDE',$data) && $data['GUIDE'] && strlen($data['GUIDE']) > 0)
                        $guide = $data['GUIDE'];
                    
                    $txt = str_replace("\x92","\'",$txt);
                    $guide = str_replace("\x92","\'",$guide);
                    
                    $txt = groomHTML($txt);
                    $guide = groomHTML($guide);
                    $DB->updateSubAttribute($suba['idsubattribute'],$txt,$guide);
                }
            }
        }
    }

    //Perform validation checks
    //Weightings for Questions
    $tot = 0.0;
    $r = $DB->allQuestionsForEval($evaluation['idevaluation']);
    while ($question = $r->fetch_array())
    {
        $tot += $question['question_weighting'];
    }

    if (abs($evaluation['evaluation_total_weightings'] - $tot) > 0.0001)
    {
        $berr = true;
        $tot = $tot * 100;
        $strTot = number_format($tot,1) . "%";
        $strEval = number_format($evaluation['evaluation_total_weightings'] * 100.0,1) . "%";
        $errortext .= "Sum of the weightings do not add to that specified by Evaluation Parameter. Sum: {$strTot} Evaluation: {$strEval}";
    }

    //Weightings for Sub-attributes
    $r = $DB->allQuestionsForEval($evaluation['idevaluation']);
    while ($question = $r->fetch_array())
    {
        $tot = 0.0;
        $cnt = 0;
        $r1 = $DB->allSubForQuestion($question['idquestion']);
        while ($sub = $r1->fetch_array())
        {
            $tot +=  $sub['subattribute_weighting'];
            $cnt++;
        }
        if ($cnt > 0 && abs(1.0-$tot) > 0.0001)
        {
            $berr = true;
            $strSum = number_format($tot*100.0,1) . "%";
            if (strlen($errortext) > 0)
                $errortext .= "<br/>";
            $errortext .= "Sum of the weightings for sub-attributes to question {$question['question_identifier']} do not add to 100% - Sum {$strSum}";
        }
    }

    if ($berr)
    {
        $_SESSION['loaderror'] = $errortext;
        $DB->createAudit('Load',$user,'Batch load of questions had errors');
    }
    else
    {
        unset($_SESSION['loaderror']);
        $_SESSION['progress'] = 5;
        $_SESSION['subprogress'] = 0;

        $DB->createAudit('Load',$user,'Batch load of questions');

    }
    header("Location: {$_SESSION['returnto']}");
    exit();
}
?>
