<?php session_start(); ?>
<?php
require './includes/classEnvironment.php';
require './includes/Security.php';

require './includes/classEvaluateDB.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());

if (!isSignedIn())
{
    //Check cookie
    $UserOK = false;
    if (isset($_COOKIE['SITEINFO']))
    {
        $user = $DB->getUserByCookie($_COOKIE['SITEINFO']);
        if ($user)
        {
            SetSessionData($user);
            $UserOK = true;
        }
    }
    if (!$UserOK)
        SigninAndRedirect();
}

if (!CheckSecurity(SECURITY_ADMIN) )
{
    header("Location: SecurityError.php");
    exit();
}

function var_error_log( $object=null )
{
    ob_start();                    // start buffer capture
    var_dump( $object );           // dump the values
    $contents = ob_get_contents(); // put the buffer into a variable
    ob_end_clean();                // end capture
    error_log( $contents );        // log contents of the result of var_dump( $object )
}

//Globals

$sectiontotal = array();
$phasetotal = array();

function getEvaluatorsFor($evalid,$phaseid)
{
    global $DB;
    $userlist = array();
    $cnt = 0;
    $r1 = $DB->allTeamsForEval($evalid);
    while ($team = $r1->fetch_array(MYSQLI_ASSOC))
    {
        $r2 = $DB->allUsersForTeam($team['idteam']);
        while ($evaluator = $r2->fetch_array(MYSQLI_ASSOC))
        {
            if ($DB->userHasPhase($evaluator['iduser'],$phaseid) )
            {
                if (!isset($userlist[$evaluator['iduser']]))
                    $userlist[$evaluator['iduser']] =  $evaluator['iduser'];
            }
        }
    }
    return array_keys($userlist);
}

function score_line($evalid,$phaseid,$questionid,$subid=null)
{
    global $DB;
    global $sectiontotal;
    global $phasetotal;

    $userlist = getEvaluatorsFor($evalid,$phaseid);
    $question = $DB->getQuestion($questionid);
    $weight = $question['question_weighting'];
    if (!is_null($subid))
    {
        $sub = $DB->getSubAttribute($subid);
        $weight = $sub['subattribute_weighting'] * $weight;
    }
    $respcnt = 0;
    $r = $DB->allRespondentsForEval($evalid,'order by respondent_name_short');
    while ($respondent = $r->fetch_array(MYSQLI_ASSOC))
    {
        //Now we have a list of evaluators
        for ($i = 0; $i < count($userlist);$i++)
        {
            $userid = $userlist[$i];
            $score = $DB->getScoreDetail($userid,$evalid,$phaseid,$respondent['idrespondent'],$questionid,$subid);
            //Calculate weighted score
            if ($score && !is_null($score['score_score']))
            {
                $scorew = floatval($score['score_score']) * $weight;
                //$str = number_format($scorew,3);
                echo "{$score['score_score']},{$scorew},";

                $idx = ($i*2)+($respcnt * count($userlist) *2);
                if (isset($sectiontotal[$idx]))
                    $sectiontotal[$idx] = $sectiontotal[$idx] + $score['score_score'];
                else
                    $sectiontotal[$idx] = $score['score_score'];
                if (isset($sectiontotal[$idx+1]))
                    $sectiontotal[$idx+1] = $sectiontotal[$idx+1] + $scorew;
                else
                    $sectiontotal[$idx+1] = $scorew;

                if (isset($phasetotal[$idx]))
                    $phasetotal[$idx] = $phasetotal[$idx] + $score['score_score'];
                else
                    $phasetotal[$idx] = $score['score_score'];
                if (isset($phasetotal[$idx+1]))
                    $phasetotal[$idx+1] = $phasetotal[$idx+1] + $scorew;
                else
                    $phasetotal[$idx+1] = $scorew;
            }
            else
                echo ",,";
        }
        $respcnt++;
    }
}

function sectionLine($columns)
{
    global $sectiontotal;
    echo ",,SECTION TOTAL,,,,";
    for($i = 0;$i < $columns ;$i++)
    {
        if (isset($sectiontotal[$i]))
            echo $sectiontotal[$i] . ",";
        else
            echo ",";
    }
    echo "\r\n";
    echo "\r\n";

}

function phaseLine($columns)
{
    global $phasetotal;
    echo ",PHASE TOTAL,,,,,";
    for($i = 0;$i < $columns ;$i++)
    {
        if (isset($phasetotal[$i]))
            echo $phasetotal[$i] . ",";
        else
            echo ",";
    }
    echo "\r\n";
    echo "\r\n";
    echo "\r\n";
}

header('Content-type: text/csv');
$n = $DB->numOfEvaluations();

echo "COMPLETE DUMP OF EVALAUTE\r\n";
echo "NUMBER OF EVALUATIONS: {$n}\r\n";
echo "\r\n";

$r = $DB->allEvaluations('order by evaluation_name');
while ($evaluation = $r->fetch_array(MYSQLI_ASSOC))
{
    $evid = $evaluation['idevaluation'];
    $nRespondents = $DB->numOfRespondents($evid);
    $str = $DB->displayText($evaluation['evaluation_name']);
    echo "\"EVALUATION TITLE: {$str}\"\r\n";

    $bphase = false;
    $phaselncount = 0;
    $r1 = $DB->allPhasesForEval($evid,'order by phase_order');
    while ($phase = $r1->fetch_array(MYSQLI_ASSOC))
    {
        if ($bphase)
        {
            phaseLine($phaselncount);
        }
        $evalters = getEvaluatorsFor($evid,$phase['idphase']);
        $phaselncount = count($evalters)*$nRespondents*2;
        $bphase = true;
        $phasetotal = array();

        $str = $DB->displayText($phase['phase_name']);
        if ($phase['phase_status'] == 'defined')
            $str .=  " NOT STARTED";
        echo "\"PHASE: {$str}\"\r\n";


        echo ",,,,,,";
        $r9 = $DB->allRespondentsForEval($evid,'order by respondent_name_short');
        while ($respondent = $r9->fetch_array(MYSQLI_ASSOC))
        {
            $str = $DB->displayText($respondent['respondent_name_short']);
            echo "\"{$str}\",,";
            for ($k =0;$k < (count($evalters)-1);$k++)
                echo ",,";
        }
        echo "\r\n";


        echo ",,,,,,";
        for($j = 0; $j < $nRespondents;$j++)
        {
            for($i = 0;$i < count($evalters);$i++)
            {
                $u1 = $DB->getUser($evalters[$i]);
                $str = $DB->displayText($u1['user_name']);
                echo "{$str},,";
            }
        }
        echo "\r\n";

        $bsection = false;
        $r2 = $DB->allSectionsForEval($evid,'order by section_order');
        while ($section = $r2->fetch_array(MYSQLI_ASSOC))
        {
            //Have we already done a section
            if ($bsection)
            {
                sectionLine($phaselncount);
            }
            $bsection = true;
            $sectiontotal = array();
            $str = $DB->displayText($section['section_name']);
            echo ",\"{$str}\"\r\n";
            $r3 = $DB->allQuestionsForSection($section['idsection'],'order by question_order');
            while ($question = $r3->fetch_array(MYSQLI_ASSOC))
            {
                $str = $DB->displayText($question['question_identifier']);
                $str2 = number_format(($question['question_weighting'] * 100.0),3) . "%";
                echo ",,\"{$str}\",\"{$str2}\",";
                $r4 = $DB->allSubForQuestion($question['idquestion'],'order by subattribute_number');
                if ($r4->num_rows == 0)
                {
                    echo ",,";
                    score_line($evid,$phase['idphase'],$question['idquestion']);
                }
                else
                {
                    $b1 = false;
                    while ($sub = $r4->fetch_array(MYSQLI_ASSOC))
                    {
                        if ($b1)
                            echo "\r\n,,,,";
                        $str2 = number_format(($sub['subattribute_weighting'] * 100.0),3) . "%";
                        echo "{$sub['subattribute_number']},{$str2},";
                        $b1 = true;
                        score_line($evid,$phase['idphase'],$question['idquestion'],$sub['idsubattribute']);
                    }
                }
                echo "\r\n";
            }
        }
        if ($bsection)
            sectionLine($phaselncount);

    }
    if ($bphase)
        phaseLine($phaselncount);

}
?>