<?php session_start(); ?>
<?php
//devt.version 1.0
require './includes/classEvalSecure.php';
require './includes/classEvaluateDB.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());

function var_error_log( $object=null )
{
    ob_start();                    // start buffer capture
    var_dump( $object );           // dump the values
    $contents = ob_get_contents(); // put the buffer into a variable
    ob_end_clean();                // end capture
    error_log( $contents );        // log contents of the result of var_dump( $object )
}
$selff = htmlspecialchars($_SERVER["PHP_SELF"]);
$_SESSION['returnto'] = $selff;

$global = $DB->getGlobal();
ESecure::CheckPage(SECURITY_ADMIN);
$user = $DB->getUser($_SESSION['userid']);
ESecure::CheckUser($user);

function smartSize($s)
{
    error_log("File size for smartSize is {$s}");
    if ($s > 1000000000)
        return number_format($s/10000000000,1) . "G";
    if ($s > 1000000)
        return number_format($s/1000000,1) . "M";
    if ($s > 1000)
        return number_format($s/1000,1) . "k";
    return $s;
}
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta name="viewport" content="width=device-width" />
    <meta name="viewport" content="initial-scale=1.0" />
    <title>SCORE DOCUMENTS</title>
    <link id="myicon" rel="icon" type="image/png" href="images/Icon1.png" />
    <link href="css/Base.css" rel="stylesheet">
    <link href="css/Tasks.css" rel="stylesheet">
    <link href="css/Details.css" rel="stylesheet">
    <style>
    #mainconatiner {max-width: 1000px; margin: auto;}
    #main h1 {font-family: 'ROBOTO SLAB';color: #555;font-size: 16pt;}
    #main table {margin: 20px;}
    #main td.h2 {font-weight: bold; color: #b04900;border-top: 1px solid #888;padding-bottom: 8px;}
    #main td.td1 {width: 8px;}
    #main td.td2 {height: 8px;}
    #main td.sz {padding-left: 20px;}
    .r {text-align: right;}
    </style>
</head>
<body>
    <div class="container">
        <div id='heading'>
            <table>
                <tr><td></td><td class='ht'>nVALUATE</td><td></td></tr>
            </table>
        </div>
        <div id='menu'>
            <div class='d1 sel'>ADMIN</div>
            <div class='d1'><a href="Signout.php">SIGN OUT</a></div>
            <?php
                if (ESecure::IS_MODULE_SCORE() && Secure::CheckSecurity(SECURITY_EVALUATE))
                    echo "<div class='d1'><a href='Score'>SCORE</a></div>";
            ?>
            <?php 
                if (ESecure::IS_MODULE_ROOM())
                    echo "<div class='d1'><a href='DataRoom.php'>DATAROOM</a></div>";
            ?>
            <div class='d2'>
                <a href='Me.php'>
                    <?php if ($user) echo $user['user_name'];?>
                </a>
            </div>
            <div class='clear'></div>
        </div>
        <div id='mainconatiner'>
            <div id='main'>
                <h1>DOCUMENTS</h1>
                <table>
                    <tr><td class="h2" colspan="3">GUIDES</td></tr>
                    <tr><td class="td1"></td><td><a href="/documents/AdminGuide.pdf" download="Admin Guide.pdf">nVALUATE Score Administration Guide</a></td><td class='r sz'><?php echo smartSize(filesize("documents/AdminGuide.pdf"));?></td></tr>
                    <tr><td class="td1"></td><td><a href="/documents/EvaluatorsGuide.docx" download="Evaluation Guide Template.docx">nVALUATE Template Evaluators Guide</a></td><td class='r sz'><?php echo smartSize(filesize("documents/EvaluatorsGuide.docx"));?></td></tr>
                    <tr><td class="td2" colspan="3"></td><td></tr>
                    <tr><td class="h2" colspan="3">SAMPLES</td></tr>
                    <tr><td class="td1"></td><td><a href="/documents/nVALUATE-Sample.csv" download="nVALUATE-Sample.csv">nVALUATE Sample spreadsheet</a></td><td class='r sz'><?php echo smartSize(filesize("documents/nVALUATE-Sample.csv"));?></td></tr>
                </table>
            </div>
        </div>
    </div>
</body>
</html>


