<?php session_start(); ?>
<?php
require './includes/classEnvironment.php';
require './includes/Security.php';
require './includes/classEvalHelpers.php';
require './includes/classFormList.php';
$FL = new FormList(null);
require './includes/classEvaluateDB.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());

//Helpers
$helpers = new helpers();


$user = $DB->getUser($_SESSION['userid']);
if (!CheckSecurity(SECURITY_ADMIN) )
{
    header("Location: SecurityError.php");
    exit();
}

if (isset($_GET['j']))
{
    $params = ($helpers->decryptQueryString($_GET['j']));


    //If teams check that no questions or users are assigne to the team
    if ($params['t'] == "team")
    {
        if ($DB->numUsersForTeam($params['i']) > 0)
        {
            $_SESSION['form_error'] = "Delete error; team still has evaluators";
            if (isset($_SESSION['returnto']))
            {
                header("Location: {$_SESSION['returnto']}");
                exit();
            }
        }

        if ($DB->numQuestionSubsForTeam($params['i']) > 0)
        {
            $_SESSION['form_error'] = "Delete error; team still has questions assigned";
            if (isset($_SESSION['returnto']))
            {
                header("Location: {$_SESSION['returnto']}");
                exit();
            }
        }
    }

    if (isset($params['t']) && isset($params['k']) && isset($params['i']))
    {
        if ($params['t'] == "phase")
        {
            //Ensure that we delete all users assigned to the phase first
            $DB->deleteUsersForPhase($params['i']);
        }

        if ($params['t'] == "user")
        {
            //Remove the user from every team and phase;
            $DB->deleteUserFromAllTeams($params['i']);
            $DB->deleteUserFromAllPhases($params['i']);
            $DB->deleteUser($params['i']);
        }
        else
        {
            $DB->delete("delete from {$params['t']}  where {$params['k']} = {$params['i']}");
        }
        $DB->createAudit('table',$user,"Delete table record {$params['i']}",$params['t']);
    }

    if (isset($_SESSION['returnto']))
        header("Location: {$_SESSION['returnto']}");
}
?>