<?php
session_start();
set_time_limit (3600);
require './includes/classEvalSecure.php';
require './includes/classEvaluateDB.php';
require './includes/classFormList.php';
require './includes/classWordDoc.php';
require './includes/classEvalHelpers.php';
require './includes/classTime.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());
Secure::CheckPage(SECURITY_ADMIN);
$FL = new FormList(null);
$helpers = new helpers();

function var_error_log( $object=null ,$text='')
{
    ob_start();                    // start buffer capture
    var_dump( $object );           // dump the values
    $contents = ob_get_contents(); // put the buffer into a variable
    ob_end_clean();                // end capture
    error_log( "{$text} {$contents}" );        // log contents of the result of var_dump( $object )
}

function filesInDir($dir)
{
    //Returns of all files in the directory including the directory
    $ret = array();
    $files = scandir($dir);
    foreach($files as $file)
    {
        if (is_dir("{$dir}/{$file}"))
        {
            if ($file != "." && $file != "..")
            {
                $list = filesInDir("{$dir}/{$file}");
                $ret = array_merge($ret,$list);
            }
        }
        else
        {
            array_push($ret,"{$dir}/{$file}");
        }
    }
    return $ret;
}

function replaceMarkerWith($marker,$with,$completepara=false)
{
    global $wdoc;
    if ($completepara)
    {
        $p1 = $wdoc->findParagraphWhichIncludesText($marker);
        if (!$p1)
        {
            error_log("Reporter [".__LINE__."] Unable to find marker {$marker}");
            return false;
        }
        if ($wdoc->newText($p1,$with) )
            return true;
        else
        {
            error_log("Reporter1 [".__LINE__."] replaceMarkerWith {$marker} failed.");
            return false;
        }
    }
    else
    {
        if ($wdoc->replaceText($marker,$with) )
            return true;
        else
        {
            error_log("Reporter1 [".__LINE__."] replaceMarkerWith {$marker} failed.");
            return false;
        }
    }
}

function htmlToWord($doc,$html,$parent,$template)
{
    $htmlDoc = new DOMDocument();
    $htmlDoc->loadHTML("<html><body>{$html}</body></html>");

    $body = $htmlDoc->getElementsByTagName("body");
    $children = $body->item(0)->childNodes;
    foreach ($children as $child)
    {
        if (strtoupper($child->nodeName) == "P")
        {
            $v = $template['p']->cloneNode(true);
            $doc->newText($v,$child->nodeValue);
            $parent->appendChild($v);
        }
        if (strtoupper($child->nodeName) == "UL")
        {
            $list = $child->childNodes;
            foreach ($list as $li)
            {
                if (strtoupper($li->nodeName) == "LI")
                {
                    $v = $template['li']->cloneNode(true);
                    $doc->newText($v,$li->nodeValue);
                    $parent->appendChild($v);
                }
            }
        }
    }
}

function htmlToWordBefore($doc,$html,$before,$template)
{
    $htmlDoc = new DOMDocument();
    @$htmlDoc->loadHTML("<html><body>{$html}</body></html>");

    $body = $htmlDoc->getElementsByTagName("body");
    $children = $body->item(0)->childNodes;
    foreach ($children as $child)
    {
        if (strtoupper($child->nodeName) == "P")
        {
            $v = $template['p']->cloneNode(true);
            $doc->newText($v,$child->nodeValue);
            $doc->insertParagraphBefore($v,$before);
        }
        if (strtoupper($child->nodeName) == "UL")
        {
            $list = $child->childNodes;
            foreach ($list as $li)
            {
                if (strtoupper($li->nodeName) == "LI")
                {
                    $v = $template['li']->cloneNode(true);
                    $doc->newText($v,$li->nodeValue);
                    $doc->insertParagraphBefore($v,$before);
                }
            }
        }
    }
}

$dtNow = new DateTime('now');
$reportsDir = $devt_environment->getkey("REPORTS_DIR");

//Create a new directory
$dirscratch = $reportsDir . "/{$dtNow->format('YmdHis')}";
mkdir($dirscratch);


$templatedir = $devt_environment->getkey("TEMPLATES_DIR");
$graphsdir = $devt_environment->getkey("GRAPHS_DIR");


$templatename = $templatedir . "/TemplateDebriefReport.docx";

$evalid = 0;
$phaseid = 0;
$teamid=0;
$allcomments=0;
$dtNow = new DateTime('now');
$tableidx= 0;
$evaluation = null;

$user = $DB->getUser($_SESSION['userid']);
if (!$user)
{
    header("Location: SecurityError.php");
    exit();
}
$dtNow->setTimezone(new DateTimeZone($user['user_timezone']));

if (isset($_GET['v']))
{
    $a = $FL->decryptParamRaw($_GET['v']);
    $evalid = $a['eval'];
    $phaseid = $a['phaseid'];
    $evaluation = $DB->getEvaluation($evalid);
}

if (!$evaluation)
{
    echo "Invalid evaluation parameter passed";
    exit();
}

//Check phase is single score
$phasecheck = $DB->getPhase($phaseid);
if (!$phasecheck)
{
    error_log("DebriefReport9 Invalid phase passed");
    echo "Invalid evaluation phase passed";
    exit();
}

if (!$phasecheck['phase_single_score'])
{
    error_log("DebriefReport9 Phase is not marked as single_score");
    echo "Last phase passed is not marked as single score";
    exit();
}

//Get some evaluation details
$numEvaluators = $DB->numOfEvaluators();
$numResponders = $DB->numOfRespondents($evalid);
$numQuestions = $DB->numOfQuestionsForEval($evalid);
$numSections = $DB-> numOfSectionsForEval($evalid);
$numPhases = $DB->numPhasesForEval($evalid);
$strtotalweightings = sprintf("%3.1f%%",$evaluation['evaluation_total_weightings']*100.0);
$finalphase = $DB->getFinalPhase($evalid);

$evaltotalweighting = $evaluation['evaluation_total_weightings'];

//Start and end phases
$startPhase = null;
$lastPhase = null;

$bf = false;
$r = $DB->allPhasesForEval($evalid,"order by phase_order");
while ($phase = $r->fetch_array(MYSQLI_ASSOC))
{
    if (!$bf)
    {
        $startPhase = $phase;
        $bf = true;
    }
    $lastPhase = $phase;
}

//Loop here for each repondent
$cntRespondent = 0;
$r = $DB->allRespondentsForEval($evalid, "order by respondent_name_full");
$numofrespondents = $r->num_rows;
while ($respondent = $r->fetch_assoc())
{
    $shortname = stripslashes(trim($respondent['respondent_name_short']));
    $shortname = str_replace(" ","_",$shortname);

    $reportTitle = $dirscratch . "/DebriefReport_{$shortname}.docx";
    //$reportTitle = $dirscratch . "/DebriefReport" . sprintf("%04d",$cntRespondent) .  ".docx";
    $wdoc = new WordDoc("/tmp/Report{$dtNow->format('YmdHis')}");
    if (!$wdoc->open("{$templatename}") )
    {
        echo "Unable to open template document {$templatename}";
        exit();
    }

    /***********************************************************************
    FIRST PAGE
    */
    replaceMarkerWith('8237469438',$evaluation['evaluation_name'],true);
    //Page 1 Date
    replaceMarkerWith('4892372387',$dtNow->format('j F Y'),true);
    replaceMarkerWith('3846385693',stripslashes($respondent['respondent_name_full']),true);


    /***********************************************************************
    PROECURMENT OUTLINE
    */
    replaceMarkerWith('5786435654',stripslashes($respondent['respondent_name_full']),false);
    replaceMarkerWith('7456787645',stripslashes($evaluation['evaluation_name']),false);


    //Details
    $tableidx = 1;
    $tbl = $wdoc->findDocElement(WORDDOC_TABLE,$tableidx);

    //First score
    $audit = $DB->firstScoreForEval($evalid);
    $strt = "";
    if ($audit)
    {
        $strt = classTimeHelpers::timeFormat($audit['audit_timestamp'],"d/m/Y",$user['user_timezone']);
    }
    $row = $wdoc->findNthElement("w:tr",3,$tbl);
    $wdoc->updateRowColumnText($row,2,$strt);

    //Number of responders
    $row = $wdoc->findNthElement("w:tr",5,$tbl);
    $wdoc->updateRowColumnText($row,2,strval($numResponders));

    //Number of responders
    $row = $wdoc->findNthElement("w:tr",6,$tbl);
    $wdoc->updateRowColumnText($row,2,strval($numEvaluators));

    /***********************************************************************
    Evaluation Summary
    */

    $tableidx += 1;
    $tbl = $wdoc->findDocElement(WORDDOC_TABLE,$tableidx);
    $row3 = $wdoc->findNthElement("w:tr",3,$tbl);
    $row4 = $wdoc->findNthElement("w:tr",4,$tbl);
    $row5 = $wdoc->findNthElement("w:tr",5,$tbl);

    $grandtotal = 0.0;
    $qcount = 0;
    $r1 = $DB->allSectionsForEval($evalid);
    while ($section = $r1->fetch_assoc())
    {
        $newrow = $row3->cloneNode(true);
        $wdoc->updateRowColumnText($newrow,1,stripslashes($section['section_name']));
        $r2 = $DB->allQuestionsForSection($section["idsection"]);
        $wdoc->updateRowColumnText($newrow,2,$r2->num_rows);
        $sum = 0.0;
        while ($question = $r2->fetch_assoc())
        {
            $sum += $question['question_weighting'];
            $qcount++;
        }
        $grandtotal += $sum;
        $wdoc->updateRowColumnText($newrow,3,sprintf("%3.0f%%",$sum*100.0));
        $wdoc->tableNewRow($tbl,$newrow);
    }

    $newrow = $row4->cloneNode(true);
    $wdoc->tableNewRow($tbl,$newrow);

    $newrow = $row5->cloneNode(true);
    $wdoc->updateRowColumnText($newrow,2,$qcount);
    $wdoc->updateRowColumnText($newrow,3,sprintf("%3.0f%%",$grandtotal*100.0));
    $wdoc->tableNewRow($tbl,$newrow);

    $wdoc->tableDeleteRow($tbl,1);
    $wdoc->tableDeleteRow($tbl,1);
    $wdoc->tableDeleteRow($tbl,1);
    $wdoc->tableDeleteRow($tbl,1);

    //$section 4 Evaluation results
     $data = $DB->weightedSectionScoresForAll($evalid,$phaseid);
     $rank = $DB->rankTotalWeightedScores($evalid,$phaseid,$respondent['idrespondent']);

     $strT = sprintf("%3.1f",$data[$respondent['idrespondent']] ['total']);
     $strW = sprintf("%3.1f",$evaltotalweighting* 100.0);
     $strP = sprintf("%3.1f%%",($data[$respondent['idrespondent']] ['total'] / $evaltotalweighting));

     replaceMarkerWith('7856745974',$strT);
     replaceMarkerWith('6765234454',$strW);
     replaceMarkerWith('9785634455',$strP);
     replaceMarkerWith('3546870473',strval($rank));
     replaceMarkerWith('7856452312',strval($numofrespondents));


    $strname = "/imgdebrief" . sprintf("%05d",$respondent['idrespondent']) . ".png";
    if ($graphdata = file_get_contents($graphsdir . $strname))
    {
        $imgp = $wdoc->findImagePara(1,$startnode);
        $imgname = $wdoc->getImageParaFileName(2);
        $wdoc->replaceImage(basename($imgname),$graphdata);
    }


    /* Score comparison
    */
    $tableidx += 1;
    $tbl = $wdoc->findDocElement(WORDDOC_TABLE,$tableidx);
    $row4 = $wdoc->findNthElement("w:tr",4,$tbl);
    $row5 = $wdoc->findNthElement("w:tr",5,$tbl);
    $row6 = $wdoc->findNthElement("w:tr",6,$tbl);

    //Add a blank row
    $newrow = $row5->cloneNode(true);
    $wdoc->tableNewRow($tbl,$newrow);

    //Add data
    $mintot = null;
    $maxtot = null;
    $totless50 = 0;
    $totsum = 0;
    $totcnt = 0;
    $totsumother = 0;
    $totcntother = 0;

    $r1 = $DB->allSectionsForEval($evalid);
    while ($section = $r1->fetch_assoc())
    {
        $a = $DB->rawSectionScoreForRespondent($evalid,$phaseid,$section['idsection'],$respondent['idrespondent']);
        $b = $DB->rawSectionScoreForOtherRespondents($evalid,$phaseid,$section['idsection'],$respondent['idrespondent']);
        $rank = $DB->rankSectionRawScores($evalid,$phaseid,$section['idsection'],$respondent['idrespondent']);

        //Add data
        $newrow = $row4->cloneNode(true);
        $wdoc->updateRowColumnText($newrow,1,stripslashes($section['section_name']));

        if ($mintot === null)
            $mintot = intval($a['min']);
        if (intval($a['min']) < $mintot)
            $mintot = intval($a['min']);

        $strN = intval($a['min']);
        $wdoc->updateRowColumnText($newrow,2,$strN);

        if ($maxtot === null)
            $maxtot = intval($a['max']);
        if (intval($a['max']) > $maxtot)
            $maxtot = intval($a['max']);

        $strN = intval($a['max']);
        $wdoc->updateRowColumnText($newrow,3,$strN);

        $totless50 += intval($a['less50']);
        $strN = intval($a['less50']);
        $wdoc->updateRowColumnText($newrow,4,$strN);

        $totsum += intval($a['sum']);
        $totcnt += intval($a['cnt']);

        $avg = 0;
        if ($a['cnt'] > 0)
            $avg = floatval(intval($a['sum']) / intval($a['cnt']));

        $strf = sprintf("%3.1f",$avg);
        $wdoc->updateRowColumnText($newrow,5,$strf);

        $totsumother += intval($b['sum']);
        $totcntother += intval($b['cnt']);

        $avg = 0;
        if ($b['cnt'] > 0)
            $avg = floatval(intval($b['sum']) / intval($b['cnt']));

        $strf = sprintf("%3.1f",$avg);
        $wdoc->updateRowColumnText($newrow,6,$strf);

        $wdoc->updateRowColumnText($newrow,7,intval($rank));

        $wdoc->tableNewRow($tbl,$newrow);
    }

    //Add a blank row
    $newrow = $row5->cloneNode(true);
    $wdoc->tableNewRow($tbl,$newrow);

    //Do totals
    $newrow = $row6->cloneNode(true);
    $wdoc->updateRowColumnText($newrow,2,$mintot);
    $wdoc->updateRowColumnText($newrow,3,$maxtot);
    $wdoc->updateRowColumnText($newrow,4,$totless50);

    $avg = 0;
    if ($totcnt > 0)
        $avg = floatval($totsum) / intval($totcnt);
    $strf = sprintf("%3.1f",$avg);
    $wdoc->updateRowColumnText($newrow,5,$strf);

    $avg = 0;
    if ($totcntother > 0)
        $avg = floatval($totsumother) / intval($totcntother);
    $strf = sprintf("%3.1f",$avg);
    $wdoc->updateRowColumnText($newrow,6,$strf);


    $rank = $DB->rankTotalRawScores($evalid,$phaseid,$respondent['idrespondent']);
    $wdoc->updateRowColumnText($newrow,7,intval($rank));

    $wdoc->tableNewRow($tbl,$newrow);


    $wdoc->tableDeleteRow($tbl,2);
    $wdoc->tableDeleteRow($tbl,2);
    $wdoc->tableDeleteRow($tbl,2);
    $wdoc->tableDeleteRow($tbl,2);

    /* Weighted scores
    */
    $tableidx += 1;
    $tbl = $wdoc->findDocElement(WORDDOC_TABLE,$tableidx);
    $row3 = $wdoc->findNthElement("w:tr",3,$tbl);
    $row4 = $wdoc->findNthElement("w:tr",4,$tbl);
    $row5 = $wdoc->findNthElement("w:tr",5,$tbl);
    $row6 = $wdoc->findNthElement("w:tr",6,$tbl);

    $sumw = 0.0;
    $sums = 0.0;

    //Add a blank row
    $newrow = $row4->cloneNode(true);
    $wdoc->tableNewRow($tbl,$newrow);

    //Add data
    $r1 = $DB->allSectionsForEval($evalid);
    while ($section = $r1->fetch_assoc())
    {
        $a = $DB->weightedSectionScoreForRespondent($evalid,$phaseid,$section['idsection'],$respondent['idrespondent']);
        //Get the range
        $b = $DB->rangeScoresForSection($evalid,$phaseid,$section['idsection']);

        $sumw += $a['totalweightings'];
        $sums += $a['weightedscore'];

        $newrow = $row3->cloneNode(true);
        $wdoc->updateRowColumnText($newrow,1,stripslashes($section['section_name']));

        $strw = sprintf("%3.1f%%",$a['totalweightings']*100.0);
        $wdoc->updateRowColumnText($newrow,2,$strw);


        $strScore = sprintf("%3.3f",$a['weightedscore']);
        $wdoc->updateRowColumnText($newrow,3,$strScore);

        $strMin = sprintf("%3.3f",$b['min']);
        $strMax = sprintf("%3.3f",$b['max']);
        $wdoc->updateRowColumnText($newrow,4,"{$strMin} - {$strMax}");


        $wdoc->tableNewRow($tbl,$newrow);
    }

    //Add a blank row
    $newrow = $row4->cloneNode(true);
    $wdoc->tableNewRow($tbl,$newrow);

    //Total row
    $tot1 = $DB->rangeTotalScores($evalid,$phaseid);



    $newrow = $row5->cloneNode(true);
    $strw = sprintf("%3.1f%%",$sumw*100.0);
    $strs = sprintf("%3.3f",$sums);

    $wdoc->updateRowColumnText($newrow,2,$strw);
    $wdoc->updateRowColumnText($newrow,3,$strs);

    $strMin = sprintf("%3.3f",$tot1['min']);
    $strMax = sprintf("%3.3f",$tot1['max']);
    $wdoc->updateRowColumnText($newrow,4,"{$strMin} - {$strMax}");


    $wdoc->tableNewRow($tbl,$newrow);

    //Blank row
    $newrow = $row4->cloneNode(true);
    $wdoc->tableNewRow($tbl,$newrow);


    //Rank
    $newrow = $row6->cloneNode(true);
    $wdoc->updateRowColumnText($newrow,3,strval($rank));
    $wdoc->tableNewRow($tbl,$newrow);


    $wdoc->tableDeleteRow($tbl,1);
    $wdoc->tableDeleteRow($tbl,1);
    $wdoc->tableDeleteRow($tbl,1);
    $wdoc->tableDeleteRow($tbl,1);
    $wdoc->tableDeleteRow($tbl,1);

    //***********************************************************************************************
    //Cooments
    //***********************************************************************************************
    $heading3 = $wdoc->findParagraphWhichIncludesText("1624538765");
    $heading4 = $wdoc->findParagraphWhichIncludesText("4755638549");
    $para = $wdoc->findParagraphWhichIncludesText("1234564267");
    $marker = $wdoc->findParagraphWhichIncludesText("MARKER");
    $r1 = $DB->allSectionsForEval($evalid);
    while ($section = $r1->fetch_assoc())
    {
        $wdoc->insertParaClonedFromBefore($heading3,$marker,stripslashes($section['section_name']),"1624538765");
        $r2 = $DB->allQuestionsForSection($section['idsection']);
        while ($question = $r2->fetch_assoc())
        {
            //Determine if we have any commnets for this question first.
            $count_comments = 0;
            $r3 = $DB->allScoresForQuestionForRespondent($evalid,$phaseid,0,$question['idquestion'],$respondent['idrespondent']);
            while ($score = $r3->fetch_assoc())
            {
                if ($score['score_comment'] && strlen($score['score_comment']) > 0)
                {
                    $count_comments++;
                    break;
                }
            }

            if ($count_comments > 0)
            {
                $quesdtiontext = stripslashes($question['question_identifier']);
                if (substr(strtoupper($quesdtiontext),0,8) != "QUESTION")
                    $quesdtiontext = "QUESTION " . $quesdtiontext;
                $wdoc->insertParaClonedFromBefore($heading4,$marker,$quesdtiontext,"4755638549");
                $addedComment = false;

                $r3 = $DB->allScoresForQuestionForRespondent($evalid,$phaseid,0,$question['idquestion'],$respondent['idrespondent']);
                while ($score = $r3->fetch_object("score"))
                {
                    if ($score->score_comment->length() > 0)
                    {
                        $wdoc->insertMultiParaClonedFromBefore($para,$marker,$score->score_comment->toWord());
                        $addedComment = true;
                    }
                }

                if (!$addedComment)
                    $wdoc->insertParaClonedFromBefore($para,$marker,"No comments made");
            }
        }
    }

    $wdoc->deleteParagraphWithText("1624538765");
    $wdoc->deleteParagraphWithText("4755638549");
    $wdoc->deleteParagraphWithText("1234564267");
    $wdoc->deleteParagraphWithText("MARKER");


    $wdoc->SaveAs($reportTitle);
    $cntRespondent++;

}

header("Content-Type: application/zip");
header('Content-Disposition: attachment; filename="DebriefReports.zip"');

$dest = $reportsDir . "/DebriefReports.zip";
$zip = new ZipArchive();
$zip->open($dest, ZipArchive::CREATE | ZipArchive::OVERWRITE);
$files = filesInDir($dirscratch);
foreach ($files as $file)
{
    $name = substr($file, strlen($dirscratch) + 1);
    if (!$zip->addFile($file,$name) )
        error_log("nvaluate::DebriefReport9.php Error adding file {$file}");
}
$zip->close();
echo file_get_contents($dest);

?>