<?php session_start(); ?>
<?php
require './includes/classEvalSecure.php';
require './includes/classEvalHelpers.php';
require './includes/classEvaluateDB.php';
require './includes/classFormList.php';
require './includes/classSiem.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());
$SIEM = new devt\siem\siem($devt_environment->getkey("SIEMHOST"));

$SEC = new ESecure();

//Helpers
$helpers = new helpers();

$selff = htmlspecialchars($_SERVER["PHP_SELF"]);
$instancename = $devt_environment->getkey("DATABASE_NAME");

$_SESSION['returnto'] = $selff;

$global = $DB->getGlobal();
ESecure::CheckPage(SECURITY_ADMIN);
$user = $DB->getUser($_SESSION['userid']);
ESecure::CheckUser($user);

function var_error_log( $object=null ,$text='')
{
    ob_start();                    // start buffer capture
    var_dump( $object );           // dump the values
    $contents = ob_get_contents(); // put the buffer into a variable
    ob_end_clean();                // end capture
    error_log( "{$text} {$contents}" );        // log contents of the result of var_dump( $object )
}

//Globals
$errtext = "";
$evaluation = null;

if ($_SERVER["REQUEST_METHOD"] == "POST")
{
    if (!Secure::checkCSRF())
    {
        $SIEM->createSecurityEntry("csrf",SECUITY_INVALID_CSRF,"minor",getenv("VAULT_SHELF"),"Invalid CSRF in Create Evaluation");
        $DB->createSecurityAudit($user, __FILE__ . "[".__LINE__."] Failed CSRF check");
        header("Location: SecurityError.php");
        exit();
    }

    $evalname = FormList::getField("name");
    $weightings = FormList::getField("w");
    if (strpos($weightings,"%") !== false)
        $weightings = floatval($weightings) / 100.0;
    else
        $weightings = floatval($weightings);

    //Validations
    $bValid = true;
    if (strlen($evalname) == 0)
    {
        $bValid = false;
        $errtext .= "An entry is required for Evaluation Name<br/>";
    }

    if ($bValid)
    {
        if ($DB->createEvaluation($evalname,$weightings) )
        {
            $evalid = $DB->insert_id;
            $evaluation = $DB->getEvaluation($evalid);

            $DB->createAudit("create",$user,"New Evaluation Created {$evalname}");
            if ($evaluation)
            {
                $_SESSION['current_evaluation'] = $evaluation['idevaluation'];
                $_SESSION['progress'] = 2;
                $_SESSION['subprogress'] = 0;
                header("Location: Setup.php");
                exit();
            }
        }
        $errtext .= "Unable to create evaluation, please seek support.<br/>";
    }
}

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta name="viewport" content="width=device-width" />
    <meta name="viewport" content="initial-scale=1.0" />
    <title>ADMIN</title>
    <link href="css/Base.css" rel="stylesheet">
    <link href="css/Tasks.css" rel="stylesheet">
    <link href="css/Details.css" rel="stylesheet">
    <style>
        #main {max-width: 600px;margin: auto; margin-top: 20px}
        input[type='submit']:hover {background-color: #cef5ce;}
        p.p2 {margin-bottom: 0; font-size: 8pt;}
        input {display: block;margin-bottom: 15px;font-size: 14pt;}
        input.req {border-color: #37ff66;}
        .err {color: red;}
        p.back {color: blue; cursor: pointer;}
    </style>
    <script>
        function f_back() {
            window.location = "Admin.php";
        }
    </script>
</head>
<body>
  <div class="container">
    <div id='heading'>
        <table>
            <tr><td></td><td class='ht'>nVALUATE</td><td></td></tr>
        </table>
    </div>
    <div id='menu'>
        <div class='d1'><a href='Admin.php'>ADMIN</a></div>
        <div class='d1 sel'>SETUP</div>
        <div class='d1'><a href='Run.php?prog=0'>RUN</a></div>
        <div class='d1'><a href='Maintenance.php?prog=2'>MAINTENANCE</a></div>
        <div class='d1'><a href='Score'>SCORE</a></div>
        <?php 
            if (ESecure::IS_MODULE_ROOM())
                echo "<div class='d1'><a href='DataRoom.php'>DATAROOM</a></div>";
        ?>
        <div class='d2'>
            <a href='Me.php'>
                <?php if ($user) echo $user['user_name'];?>
            </a>
        </div>
        <div class='clear'></div>
    </div>
    <div id='main'>
        <div id="form">
            <form method="post" action='<?php echo $selff;?>'>
                <p class="p2">* EVALUATION NAME</p>
                <input class="req" type="text" size="50" name="name" maxlength="100" />
                <p class="p2">* SUM OF QUESTION WEIGHTINGS</p>
                <input class="req" type="text" size="5" name="w" />
                <?php echo "<input type='hidden' name='formtoken' value='{$_SESSION['csrf_key']}' />";?>
                <input type="submit" size="5" name="create" value="CREATE NEW"/>
                <p class="back" onclick="f_back()">&lt;&lt;BACK</p>
            </form>
            <?php
            echo "<p class='err'>{$errtext}</p>";
            ?>
        </div>
    </div>
  </div>
</body>
</html>
