<?php session_start(); ?>
<?php
require './includes/classEnvironment.php';
require './includes/Security.php';

require './includes/classEvaluateDB.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());

function decrypt($data) 
{
    if (isset($_SESSION['session_key']))
    {
            
        // Remove the base64 encoding from our key
        $encryption_key = base64_decode($_SESSION['session_key']);
        // To decrypt, split the encrypted data from our IV - our unique separator used was "::"
        list($encrypted_data, $iv) = explode('::', base64_decode($data), 2);
        return openssl_decrypt($encrypted_data, 'aes-256-cbc', $encryption_key, 0, $iv);
    }
    else
        return null;
}

if (isset($_GET['v'])) 
{
    $d = decrypt($_GET['v']);
    if (strlen($d) >= 4 && substr($d,0,4) == 'FFFF')
    {
        if (! $user = $DB->getUser($_SESSION['userid']) )
        {
            header("Location: SecurityError.php?err=invdocref");
            exit();
        }
        $id = intval(substr($d,4,strlen($d)-4));
        if ($doc = $rec = $DB->getDoc($id) )
        {
            //Need to check security
            if (!$DB->userhasdocaccess($user['iduser'],$id) )
            {
                header("Location: SecurityError.php?err=docnotallowed");
                exit();
            }
            
            //Audit the access
            if (!$DB->createDocAccessAudit($user['iduser'],$doc['iddoclist']) )
            {
                header("Location: DataroomError.php?err=audit");
                exit();
            }
            $dir = $devt_environment->getkey("DOC_STORE");
            if (substr($dir, -1) != "/")
                $dir .= "/";
            $strTitle = $dir . $doc['doclist_file'];
            
            $rslt = decryptAttachment($strTitle,$devt_environment->getkey("ATTACHKEY"));
            if ($rslt)
            {
                header("Content-Type: {$doc['doclist_mime']}");
                header("Content-Disposition: attachment; filename={$doc['doclist_title']}");
                echo $rslt;
            }
            else
                http_response_code(404);
            exit();
        }
        else
        {
            http_response_code(404);
        }
    }
    else 
    {
        header("Location: SecurityError.php?err=invdocref");
        exit();
    }
}
else
    http_response_code(404);
?>