<?php session_start(); ?>
<?php
require './includes/classSecure.php';
require './includes/classFormList.php';
require './includes/classEvaluateDB.php';
require './includes/classSiem.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());
$SIEM = new devt\siem\siem($devt_environment->getkey("SIEMHOST"));

header('Content-Type: application/json');

function var_error_log( $object=null ,$text='')
{
    ob_start();                    // start buffer capture
    var_dump( $object );           // dump the values
    $contents = ob_get_contents(); // put the buffer into a variable
    ob_end_clean();                // end capture
    error_log( "{$text} {$contents}" );        // log contents of the result of var_dump( $object )
}

function returnError($t)
{
    global $n;

    $rslt=array();
    $rslt['status'] = "ERROR";
    $rslt['error'] = $t;
    $rslt['idx'] = $n;
    echo json_encode($rslt);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST')
{
    $userid = 0;
    $desc = '';
    $n = -1;
    $err = false;
    $p = null;

    if(isset($_SESSION['userid']))
        $userid = $_SESSION['userid'];
    if (!$user = $DB->getUser($userid))
        returnError("Invalid user");

    if (!Secure::checkCSRF())
    {
        $SIEM->createSecurityEntry("csrf",SECUITY_INVALID_CSRF,"minor",getenv("VAULT_SHELF"),"Invalid CSRF in Upload");
        $DB->createSecurityAudit($user,"Upload.php [".__LINE__."] Failed CSRF check");
        returnError("Failed CSRF");
        exit();
    }

    $dir = $devt_environment->getkey("DOC_STORE");
    if (substr($dir, -1) != "/")
        $dir .= "/";

    $roomSettings = $DB->getDataroom();


    if (isset($_POST['fileidx'])) $n = intval($_POST['fileidx']);
    if (isset($_POST['parent'])) $p = intval($_POST['parent']);

    if ($n < 0)
        returnError("Inernal Error No file index specified");

    $desc = FormList::getField('description');

    if (isset($_FILES['file']))
    {
        $file = $_FILES['file'];
        $mime = Secure::cleanAndCheckMime($file['type']);
        if (!$mime)
        {
            $SIEM->createSecurityEntry("content",SECURITY_MIME,"minor",getenv("VAULT_SHELF"),"Attempt to upload file with invalid mime string");
            $DB->createSecurityAudit($user,"Attempt to upload file with invalid mime string {$file['type']}");
            returnError("Security check - File type sepcified misformed");
        }

        $determined_mime = mime_content_type ($file["tmp_name"]);
        if ($roomSettings['dataroom_strict_mime_check'])
        {
            if (strtoupper($mime) != strtoupper($determined_mime))
            {
                $SIEM->createSecurityEntry("content",SECURITY_MIME,"minor",getenv("VAULT_SHELF"),"Strict mime type not matched");
                $DB->createSecurityAudit($user,"Upload.php [".__LINE__."] mimes differ options strict set {$file['type']} | {$determined_mime} ");
                returnError("Security check - File type given different from determined - Dataroom strict type checking set");
            }
        }

        if (!$roomSettings['dataroom_allow_all_file_types'])
        {
            //We need to check this mim type against a the allowed mimes
            $mimrec = $DB->getMimeByMime($mime);
            if (!$mimrec || !$mimrec['mime_enabled'])
            {
                returnError("Security check - Files of this type not permitted for upload");
            }
        }

        $ext = pathinfo($file["name"], PATHINFO_EXTENSION);
        $salt = Secure::createSalt();
        $storedname = $salt . "." . $ext;
        $target_file = $dir . $storedname;

        if (! Secure::encryptAttachment($file["tmp_name"],$target_file,$devt_environment->getkey("ATTACHKEY")) )
        {
            returnError("File encryption failed");
        }

        //Sign the file
        $signature = '';
        $privatekey = file_get_contents("/etc/nvaluate/keys/.signature/Signature.key");
        if ($privatekey)
        {
            $data = file_get_contents($file["tmp_name"]);
            if (openssl_sign ($data,$signature ,$privatekey, OPENSSL_ALGO_SHA256 ) )
            {
                $signature = bin2hex($signature);
            }
            else
            {
                error_log("Upload of file: Unable to sign content");
                $signature = '';
            }
        }

        if (!$DB->newFile($userid,basename($file["name"]),$desc,$storedname,$mime,$file['size'],$signature,$p) )
            returnError("Failed to store");

        //We need to remove the temporary files
        unlink($file["tmp_name"]);

        $rslt=array();
        $rslt['status'] = "OK";
        $rslt['idx'] = $n;
        echo json_encode($rslt);
        exit();
    }
    else
        returnError("Missing file");
}
else
    returnError("Invalid call to Upload");
?>