<?php
session_start();
require './includes/classEvalSecure.php';
require './includes/classFormList.php';
require './includes/classEvaluateDB.php';
require './includes/classSiem.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());
$SIEM = new devt\siem\siem($devt_environment->getkey("SIEMHOST"));
$FL = new FormList(null);

Secure::CheckPage(SECURITY_ADMIN);
$DataRoom = $DB->getDataroom();
$user = null;

if (!$user = $DB->getUser($_SESSION['userid']) )
{
    $SIEM->createSecurityEntry("user",SECURITY_INVALID_USER,"major",getenv("VAULT_SHELF"),"Invalid User in rommsettings");
    $DB->createSecurityAudit($user,"RoomSettings.php [".__LINE__."] Invalid user");
    header("Location: SecurityError.php");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST')
{
    if (!Secure::checkCSRF())
    {
        $SIEM->createSecurityEntry("csrf",SECUITY_INVALID_CSRF,"minor",getenv("VAULT_SHELF"),"Invalid CSRF in Room Settings");
        $DB->createSecurityAudit($user,"RoomSettings.php [".__LINE__."] Failed CSRF check");
        header("Location: SecurityError.php");
        exit();
    }

    if (isset($_POST['change']))
    {
        $DataRoom['dataroom_name'] = FormList::getField('name');
        $DataRoom['dataroom_two_factor'] = FormList::getCheckBoxField('twofact');
        $DataRoom['dataroom_allow_all_file_types'] = FormList::getCheckBoxField('allowall');
        $DataRoom['dataroom_strict_mime_check'] = FormList::getCheckBoxField('strict');

        if (!$DB->p_update_from_array('dataroom',$DataRoom,'') )
            error_log("RoomSettings.php ".__LINE__." Failed to uodte dataroom settings ");
        $DataRoom = $DB->getDataroom();
    }

    if (isset($_POST['addfiletype']))
    {
        $mime = array();
        $mime['mime_name'] = FormList::getField('ftname');
        $mime['mime_mime'] = FormList::getField('ftmime');
        $mime['mime_suffix'] = FormList::getField('ftsuffix');
        $mime['mime_enabled'] = 0;
        $DB->p_create_from_array('mime',$mime);
        $mime = $DB->getMimeByMime($mime['mime_mime']);
    }

    if (isset($_POST['filetypes']))
    {
        //Reset all mime type
        $DB->disableAllMimes();
        if  (isset($_POST['whatmime']))
        {
            foreach($_POST['whatmime'] as $m)
            {
                $a = $FL->decryptParamRaw($m);
                if (isset($a['val']))
                {
                    $DB->enableMime(intval($a['val']));
                }
            }
        }
    }
}
?>
<!DOCTYPE HTML>
<html>
<head>
<meta name="viewport" content="width=device-width">
<meta name="viewport" content="initial-scale=1.0">
<title>DATAROOM SETTINGS</title>
<link href="css/Base.css" rel="stylesheet">
<style>
#main {}
#main h1 {font-size: 14pt; font-family: 'Robot Slab'; color: #555;}
#form {margin-left: 18px;}
#form p {font-size: 8pt; margin-bottom: 0;}
#form input[type='text'] {font-size: 14pt;}
#form input[type='checkbox'] {width: 16px; height: 16px;}
#form input[type='submit'] {margin-top: 40px;}
#options {margin-top: 24px; padding: 10px; border: solid 1px #888;border-radius: 6px;max-width: 600px;}
p.boxtitle {display: inline-block;top: -18px;position: relative;background-color: #f8f8f8;width: auto;margin: 0;z-index: 10;}
#settings {margin-top: 24px; padding: 10px; border: solid 1px #888;border-radius: 10px;}
#mimes {margin-top: 24px; padding: 10px; border: solid 1px #888;border-radius: 10px;}
#addfiletype {display: none;}
#filetypelist {margin-top:12px; padding: 10px; border: solid 1px #888;border-radius: 6px;}
#filetypelist p.p1 {margin-bottom: 12px; font-size: 10pt; color: #777;}
#filetypelist p.note {font-size: 10pt; color: red;margin-bottom: 12px;}
#filetypelist h1 {font-size: 12pt; color: #555;}
#filetypelist th {text-align: left; color: #555;padding-right: 20px;font-size: 10pt;}
#filetypelist td {padding-right: 20px;font-size: 10pt;color: #1290ff;}
</style>
<script>
    function dispadd(v) {
        if (v) {
            document.getElementById('addfiletype').style.display = 'block';
            document.getElementById('filetypelist').style.display = 'none';
        }
        else {
            document.getElementById('addfiletype').style.display = 'none';
            document.getElementById('filetypelist').style.display = 'block';
        }
    }
</script>
</head>
<body>
<div id='container'>
    <div id='heading'>
        <table>
            <tr><td></td><td class='ht'>nVALUATE</td><td></td></tr>
        </table>
    </div>
    <div id='menu'>
        <div class='d1'><a href='Admin.php'>ADMIN</a></div>
        <?php
        if (ESecure::IS_MODULE_SCORE())
        {
            echo "<div class='d1'><a href='Setup.php?prog=0'>SETUP</a></div>";
            echo "<div class='d1'><a href='Run.php?prog=0'>RUN</a></div>";
            echo "<div class='d1'><a href='Maintenance.php'>MAINTENANCE</a></div>";
            echo "<div class='d1'><a href='Score'>SCORE</a></div>";
        }
        echo "<div class='d1'><a href='DataRoom.php'>DATAROOM</a></div>";
        ?>
        <div class='d2'><a href='Me.php'><?php if ($user) echo $user['user_name'];?></a></div>
        <div class='clear'></div>
    </div>
    <div id='main'>
        <div id="form">
            <form method='post' action='<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>'>
                <div id="settings">
                <p>DATAROOM NAME</p>
                <input type="text" name="name" size ="30" value="<?php echo $DB->displayText($DataRoom['dataroom_name'])?>" />
                <div id="options">
                    <p class="boxtitle">OPTIONS</p>
                    <p>TWO FACTOR AUTHENTICATION (Confim via two factor file upload)</p>
                    <input type="checkbox" name="twofact" <?php if ($DataRoom['dataroom_two_factor']) echo " checked ";?> />
                    <p>ALLOW ALL FILE TYPES (For security recommend NOT SET)</p>
                    <input type="checkbox" name="allowall" <?php if ($DataRoom['dataroom_allow_all_file_types']) echo " checked ";?> />
                    <p>STRICT MIME CHECK (Checks that the file type supplied with uploads matches the file.  Recommend SET)</p>
                    <input type="checkbox" name="strict" <?php if ($DataRoom['dataroom_strict_mime_check']) echo " checked ";?> />
                </div>
                <?php echo "<input type='hidden' name='formtoken' value='{$_SESSION['csrf_key']}' />"; ?>
                <input type="submit" name="change" value="CONFIRM DATAROOM SETTINGS" />
                </div>
            </form>
            <div id="mimes">
                    <h1>FILE TYPES</h1>
                    <button onclick="dispadd(true)">ADD NEW FILE TYPE</button>
                    <div id="addfiletype">
                        <form method='post' action='<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>'>
                            <p>NAME</p>
                            <input type="text" name="ftname" />
                            <p>SUFFIX</p>
                            <input type="text" name="ftsuffix" size="4"/>
                            <p>MIME</p>
                            <input type="text" name="ftmime" size="60" />
                            <?php echo "<input type='hidden' name='formtoken' value='{$_SESSION['csrf_key']}' />"; ?>
                            <br/>
                            <input type="submit" name="addfiletype" value="CONFIRM ADD" />
                            <br/>
                            <button onclick="dispadd(false)">CANCEL</button>
                            </form>
                    </div>
                    <div id="filetypelist">
                    <form method='post' action='<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>'>
                    <h1>CURRENT LIST</h1>
                    <p class="p1">To allow the upload of specific file types, select the checkbox beside the corresponding file type.</p>
                        <?php if ($DataRoom['dataroom_allow_all_file_types']) echo "<p class='note'>Note: The Dataroom setting ALLOW ALL FILE TYPES is set, whcih overrides any setting in the list below.</p>";?>
                    <table>
                        <tr><th></th><th>FILE TYPE</th><th>SUFFIX</th><th>MIME</th>
                        </tr>
                        <?php
                        $r = $DB->allMimes();
                        while ($mime = $r->fetch_array(MYSQLI_ASSOC))
                        {
                            $v = $FL->encryptParam("val={$mime['idmime']}");
                            $c = '';
                            if ($mime['mime_enabled'])
                                $c = 'checked ';
                            echo "<tr><td><input type='checkbox' name='whatmime[]' value='{$v}' {$c}/></td><td>{$DB->displayText($mime['mime_name'])}</td><td>{$DB->displayText($mime['mime_suffix'])}</td><td>{$DB->displayText($mime['mime_mime'])}</td></tr>";
                        }
                        ?>
                    </table>
                    <?php echo "<input type='hidden' name='formtoken' value='{$_SESSION['csrf_key']}' />"; ?>
                    <input type="submit" name="filetypes" value="CONFIRM FILE TYPES" />
                    </form>
                    </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>
