<?php session_start(); ?>
<?php
require './includes/classEnvironment.php';
require './includes/Security.php';
require './includes/classEvalHelpers.php';

require './includes/classEvaluateDB.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());

$selff = htmlspecialchars($_SERVER["PHP_SELF"]);
$instancename = $devt_environment->getkey("DATABASE_NAME");

$helpers = new helpers();

function var_error_log( $object=null )
{
    ob_start();                    // start buffer capture
    var_dump( $object );           // dump the values
    $contents = ob_get_contents(); // put the buffer into a variable
    ob_end_clean();                // end capture
    error_log( $contents );        // log contents of the result of var_dump( $object )
}

function CheckUserSecurity($user,$seclevel)
{
    if ($user)
    {
        if (intval($user['user_security']) & intval($seclevel))
            return true;
    }
    return false;
}

function smartSize($v)
{
    $s = intval($v);
    if ($s > 1000000)
        return floor($s / 1000000.0) . "M";
    if ($s > 1000)
        return floor($s / 1000.0) . "k";
    else
        return $s;
}


if (!isSignedIn())
{
    //Check cookie
    $UserOK = false;
    if (isset($_COOKIE['SITEINFO']))
    {
        $user = $DB->getUserByCookie($_COOKIE['SITEINFO']);
        if ($user)
        {
            SetSessionData($user);
            $UserOK = true;
        }
    }
    if (!$UserOK)
    {
        SigninAndRedirect();
        exit();
    }
}

if (! ( CheckSecurity(SECURITY_ADMIN) ))
{
    header("Location: SecurityError.php");
    exit();
}

$user = $DB->getUser($_SESSION['userid']);
if (!$user)
{
    header("Location: SecurityError.php");
    exit();
}

function buildRow($rec=null,$level=0)
{
    global $DB;
    global $user;

    $maxlevels = 10;
    $colspan = $maxlevels - $level;
    if ($rec)
    {

        //Find out who uploaded
        $uploaduser = $DB->getUser($rec['doclist_user']);
        $deleteuser = $DB->getUser($rec['doclist_deleted_user']);

        $dtup = new Datetime($rec['doclist_timestamp']);
        if ($user['user_timezone'])
           $dtup->setTimezone(new DateTimezone($user['user_timezone']));

        $strTitle = '';
        if ($rec['doclist_type'] == '2doc')
        {
            $strTitle = "Uploaded by {$DB->displayText($uploaduser['user_name'])} on {$dtup->format('D jS F Y H:i')}";
            if ($deleteuser)
            {
                $dtdel = new Datetime($rec['doclist_deleted_timestamp']);
                    if ($user['user_timezone'])
                    $dtdel->setTimezone(new DateTimezone($user['user_timezone']));
                $strTitle .= "\nDeleted by {$DB->displayText($deleteuser['user_name'])} on {$dtdel->format('D jS F Y H:i')}";
            }
        }
        echo "<tr>";

        for ($i = 0; $i < $level;$i++)
            echo "<td></td>";
        echo "<td>";
            if ($rec['doclist_type'] == '0room')
                echo "<img src='/images/Room.png' />";
            if ($rec['doclist_type'] == '1folder')
                echo "<img src='/images/Folder-Blue.png' />";
            if ($rec['doclist_type'] == '2doc')
                echo "<img src='/images/Document-Blue.png' />";
        echo "</td>";


        echo "<td class='";
        if ($rec['doclist_deleted'])
            echo " del";
        echo "' colspan='{$colspan}'  title='{$strTitle}'>{$DB->displayText($rec['doclist_title'])}</td>";

        echo "<td class='";
        if ($rec['doclist_deleted'])
            echo " del";
        echo "'>{$DB->displayText($rec['doclist_description'])}</td>";


        echo "<td class='r'>{$dtup->format('D jS F Y H:i')}</td>";
        if ($rec['doclist_type'] == '2doc')
        {
            echo "<td class='r'>{$rec['doclist_version']}</td>";
        }
        else
            echo "<td></td>";


        //Size
        if ($rec['doclist_type'] == '2doc')
        {
            $size = smartSize($rec['doclist_size']);
            echo "<td class='r'>{$size}</td>";
        }
        else
            echo "<td></td>";

        //Delete button
        if ($rec['doclist_deleted'])
            echo "<td><button value='{$rec['iddoclist']}' onclick='buttonUndelete(this)'>UN DELETE</button></td>";
        else
            echo "<td></td>";
        echo "</tr>";


    }
    $r = null;
    if (is_null($rec) )
        $r = $DB->getAllChildrenInclDeleted(null);
    else
        $r = $DB->getAllChildrenInclDeleted($rec['iddoclist']);
    while ($doc = $r->fetch_array(MYSQLI_ASSOC))
    {
        buildRow($doc,$level+1);
    }

}
?>
<!DOCTYPE HTML>
<html>
<head>
<meta name="viewport" content="width=device-width">
<meta name="viewport" content="initial-scale=1.0">
<title>nValuate File List</title>
<link href="css/Base.css" rel="stylesheet">
<link href="css/devtmenu.css" rel="stylesheet">
<style>
#main {}
#main h1 {font-size: 14pt; font-family: 'Robot Slab'; color: #555;}
#main th,td {padding-right: 12px;}
#main button {font-size: 8pt;}
#main button:hover {background-color: lime;}
.l {text-align: left;}
.c {text-align: center;}
.r {text-align: right;}
.del {text-decoration: line-through;}
</style>
<script type="text/javascript" src="apievaljsonv1.php?r=/<?php echo $user['user_apikey'];?>/devtscript/<?php echo $instancename;?>/devtcore&formtoken=<?php echo urlencode($_SESSION['csrf_key']);?>"></script>
<script type="text/javascript" src="apievaljsonv1.php?r=/<?php echo $user['user_apikey'];?>/devtscript/<?php echo $instancename;?>/eval&formtoken=<?php echo urlencode($_SESSION['csrf_key']);?>"></script>
<script>
var https = <?php if (usingHTTPS()) echo 'true'; else echo 'false';?>;
var apireplies = {'undeletefile': 'undel'};
eval.init('<?php echo $_SERVER['HTTP_HOST']?>','apievaljsonv1.php?r=','<?php echo $user['user_apikey']; ?>',https,apireplies);

function undel(d) {
    window.location = '<?php echo $selff;?>';
}

function buttonUndelete(n) {
    eval.undeletedoc(n.value);
}
</script>
</head>
<body>
    <div id='container'>
        <div id='heading'>
            <table>
                <!-- <tr><td></td><td class='ht'>GWRC Files</td><td></td></tr> -->
                <tr><td></td><td class='ht'>nVALUATE File List</td><td></td></tr>
            </table>
        </div>
        <div id='menu'>
            <div class='d1'><a href='Admin.php'>ADMIN</a></div>
            <div class='d1 sel'>FILE LIST</div>
            <?php 
                if (IS_MODULE_SCORE())
                    echo "<div class='d1'><a href='Score'>SCORE</a></div>";
            ?>
            <?php 
                if (IS_MODULE_ROOM())
                    echo "<div class='d1'><a href='DataRoom.php'>DATAROOM</a></div>";
            ?>
            <div class='d2'><?php if ($user) echo $user['user_name'];?></div>
            <div style='clear: left;'></div>
        </div>
        <div id='main'>
            <h1>DATA ROOM FILE LIST</h1>
            <table>
                <tr><th class='l' colspan='11'>NAME</th><th class='l'>DESCRIPTION</th><th class='r'>TIMESTAMP</th><th class='r'>VERSION</th><th>SIZE</th></tr>
                <?php buildRow(); ?>    
            </table>
        </div>
    </div>
</body>
</html>