<?php session_start(); ?>
<?php
//devt.Version = 1.0
require './includes/classEnvironment.php';
require './includes/Security.php';
if (!IS_MODULE_ROOM())
{
    http_response_code(404);
    exit();
}

require './includes/classEvaluateDB.php';
$DB = new EvaluateDB($devt_environment->getDatabaseParameters());

$selff = htmlspecialchars($_SERVER["PHP_SELF"]);
$instancename = $devt_environment->getkey("DATABASE_NAME");

function var_error_log( $object=null,$text='')
{
    ob_start();                    // start buffer capture
    var_dump( $object );           // dump the values
    $contents = ob_get_contents(); // put the buffer into a variable
    ob_end_clean();                // end capture
    error_log( "{$text} {$contents}" );        // log contents of the result of var_dump( $object )
}

if (!isSignedIn())
{
    //Check cookie
    $UserOK = false;
    if (isset($_COOKIE['SITEINFO']))
    {
        $user = $DB->getUserByCookie($_COOKIE['SITEINFO']);
        if ($user)
        {
            SetSessionData($user);
            $UserOK = true;
        }
    }
    if (!$UserOK)
    {
        SigninAndRedirect();
        exit();
    }
}

if (! ( CheckSecurity(SECURITY_DATAROOM_VIEW) || CheckSecurity(SECURITY_DATAROOM_LOAD) ))
{
    header("Location: SecurityError.php");
    exit();
}
$user = $DB->getUser($_SESSION['userid']);
if (!$user)
{
    header("Location: SecurityError.php");
    exit();
}

$anydocs = $DB->userhasanydoc($user['iduser']);

if ($_SERVER['REQUEST_METHOD'] == 'POST')
{
    var_error_log($_POST);  
    if (isset($_POST['newdir']) && strlen($_POST['newdir']) > 0)
    {
        $currentdir = null;
        $newdir = $_POST['newdir'];
        if (isset($_POST['current'])) $currentdir = $_POST['current'];
        $did = $DB->newFolder($user['iduser'],$newdir,$currentdir);
        if ($did)
            $_SESSION['currentfolderdid'] = $did;
        header("Location: {$selff}");
        exit();
    }
    
}
?>
<!DOCTYPE HTML>
<html>
<head>
<meta name="viewport" content="width=device-width">
<meta name="viewport" content="initial-scale=1.0">
<title>DATA ROOM</title>
<link href="css/Base.css" rel="stylesheet">
<link href="css/devtmenu.css" rel="stylesheet">
<style>
#heading {}
#nodocs {margin: 30px;}
<?php
    if ($anydocs)
        echo "#dataroom {display: flex; margin-left: 30px;}\n";
    else
        echo "#dataroom {display: none;}\n";
?>
#tree {margin: 5px;margin-left: 0px;padding: 5px;font-family: Arial, Helvetica, sans-serif;font-size: 10pt;border: 1px solid #555;background-color: #ffe;border-radius: 6px;flex-basis: 300px;position: relative;}
#tree div {white-space: nowrap; overflow: hidden;}
#tree div.l0 {padding-left: 10px; cursor: pointer;}
#tree div.l1 {padding-left: 20px; cursor: pointer;}
#tree div.l2 {padding-left: 30px; cursor: pointer;}
#tree div.l3 {padding-left: 40px; cursor: pointer;}
#tree div.l4 {padding-left: 50px; cursor: pointer;}
#tree div.l5 {padding-left: 60px; cursor: pointer;}
#tree div.l6 {padding-left: 70px; cursor: pointer;}
#tree span {padding-left: 4px;vertical-align: top;}
#treehd {font-family: 'Roboto Slab';font-weight: bold;margin-bottom: 10px;margin-left: 15px;border-radius: 6px;}
#leftcolapse {position: absolute; top: -6px; right: -20px;transform: scale(0.5);}
#leftcolapse img {opacity: 0.2;}
#leftcolapse:hover {transform: scale(1.0);}
#leftcolapse img:hover {opacity: 1.0;}
#nodocs p.pmsg1 {color: #404040; margin-left: 60px; font-size: 16pt;}
#detail {margin: 5px; padding: 5px; border: 1px solid #555;border-radius: 6px;flex-grow: 1;}
#currentfolder span.selfolder {color: blue; cursor: pointer;}
#detail h1 {font-size: 12pt; font-weight: normal;color: #777;margin-left: 15px;}
#foldermenu {background-color: #f2f2f2;}
#foldermenu button {font-size: 8pt; vertical-align: top;}
#foldermenubar {margin-left: 15px;margin-right: 15px;background-color: #eef;padding: 6px;border: solid 1px #666;border-radius: 4px;}
#foldertable {margin: 15px;margin-top: 5px;border: solid 1px #666;padding: 3px;border-radius: 3px;background-color: #ffe;}
#foldertable tr {height: 26px;}
#foldertable tr:hover {background-color: #eee;}
#foldertable th {padding-right: 15px;font-size: 9pt;color: #777;background-color: #eef;}
#foldertable td {padding-right: 15px;font-size: 9pt;color: #555;border-top: solid 1px #aaa;}
#foldertable td.td1 {width: 24px;padding-right: 0px;}
#foldertable td.tdfolder {font-weight: bold;cursor: pointer;}
#foldertable .l {text-align: left;}
#foldertable .r {text-align: right;}
#uploadform {margin: 20px;}
#uploadform input[type="file" i] {color: transparent;}
#loadlist {margin: 20px;border: solid 1px #555;}
#loadlist h2 {margin: 10px;font-size: 10pt;}
#loadlist td {padding-right: 10px;}
#loadlist td.r {text-align: right;}
#loadlist td.err {color: red;}
#loadlist td.uploaderror {color: red;text-decoration: line-through;}
#filetable {width: 100%; border-collapse: collapse;}
#filelist2 {margin-left: 15px;}
#newdir {display: none;}
#newdir h1 {font-family: 'Roboto Slab';}
#newdir p {margin-bottom: 0; font-size: 8pt;}
#newdir input[type='submit'] {margin-top: 20px;margin-bottom: 20px;}
#newdir input[type='submit']:hover {background-color: lime;}
#uploads {display: none;}
#uploads h1 {font-family: 'Roboto Slab';}
#dropzone {margin: 4px;margin-left: 20px;padding: 4px;border: solid 1px #777; width: 122px;}
</style>
<script type="text/javascript" src="apievaljsonv1.php?r=/<?php echo $user['user_apikey'];?>/devtscript/<?php echo $instancename;?>/devtcore&formtoken=<?php echo urlencode($_SESSION['csrf_key']);?>"></script>
<script type="text/javascript" src="apievaljsonv1.php?r=/<?php echo $user['user_apikey'];?>/devtscript/<?php echo $instancename;?>/eval&formtoken=<?php echo urlencode($_SESSION['csrf_key']);?>"></script>
<script type="text/javascript" src="apievaljsonv1.php?r=/<?php echo $user['user_apikey'];?>/devtscript/<?php echo $instancename;?>/devtmenu&formtoken=<?php echo urlencode($_SESSION['csrf_key']);?>"></script>
<script>
var g_tree = null;
<?php
    if (isset($_SESSION['currentfolderdid']))
    {
        echo "var currentfolderDid = {$_SESSION['currentfolderdid']};";
        unset($_SESSION['currentfolderdid']);
    }
    else
        echo "var currentfolderDid = null;";
?>
var treenodestatus = [];
var filelist = [];
var filecnt = 0;
var treecollapse = false;
var g_formtoken = "<?php echo $_SESSION['csrf_key'];?>";
var g_formtoken_encoded = "<?php echo urlencode($_SESSION['csrf_key']);?>";

var g_maxfilesize = <?php echo intval(ini_get('post_max_size')) * 1048576;?>;
var g_candelete = <?php if (CheckSecurity(SECURITY_DATAROOM_DELETE)) echo "true"; else echo "false";?>;
var https = <?php if (usingHTTPS()) echo 'true'; else echo 'false';?>;
var apireplies = {'alldocs': 'updDocs','changefilename': 'nameChanged'};
eval.init('<?php echo $_SERVER['HTTP_HOST']?>','apievaljsonv1.php?r=','<?php echo $user['user_apikey']; ?>',https,apireplies);
document.addEventListener('contextmenu', function(e) {
            //alert("You've tried to open context menu"); //here you draw your own menu
            //e.preventDefault();
        }, false);

document.addEventListener('click', function(e) {
            devtmenu.removeAll();
        }, false);

function removeAllChildren(n) {
    while (n.firstChild)
        n.removeChild(n.firstChild);
}

function anyChildrenFolders(d) {
    if (devt.def(d.children) && d.children.length > 0) {
        for (var i = 0; i < d.children.length;i++) {
            if (d.children[i].type.substr(0,1) == '1')
                return true;
        }
    }
    return false;
}

function smartSize(v) {
    var s = parseInt(v);
    if (s > 1000000)
        return Math.floor(s / 1000000.0) + "M";
    if (s > 1000)
        return Math.floor(s / 1000.0) + "k";
    else
        return s;
}

function buildfullpathname (n,str) {
    if (str.length > 0)
        str += "/";
    if (devt.def(n.title))
    {
        str += n.title;
    }
    n.fullpath = str;
    if (devt.def(n.children)) {
        for (var i= 0; i < n.children.length; i++) {
            buildfullpathname (n.children[i],str);    
        }
    }
}

function updDocs(d) {
    console.log("Upd Docs received: current folder = " + currentfolderDid);
    g_tree = d.tree;
    buildfullpathname(g_tree,''); 
    if (!currentfolderDid)
        currentfolderDid = getFirstNode();
    displayTree(g_tree,'tree2');
    buildDetailList(currentfolderDid);
}

function getFirstNode() {
    if (g_tree) {
        if (devt.def(g_tree.children) && devt.def(g_tree.children[0]) )
            return g_tree.children[0];
    }
    return null;
}

function getDidNode(n,did) {
    if (n.id == did)
        return n;
    if (devt.def(n.children)) {
        for (var i= 0; i < n.children.length; i++) {
            var r = getDidNode(n.children[i],did);
            if (r)
                return r;
        }
    }
    return null;    
}

function getDidTreeDiv(did) {
    n = devt.ge('tree');
    var l = n.getElementsByTagName('DIV');
    for (var i=0;i < l.length;i++) {
        var id = l[i].getAttribute('did');
        if (did == id)
            return l[i];
    }
    return null;
}

function nameChanged(d) {
    location.reload();
}

function rightClick(n,e) {
    e.preventDefault();
    var treedata = n.treedata;
    if (devt.def(n.ftype)) {
        if (n.ftype == 0) { // room
            var m = new devtmenu.menu('body',n);
            m.additem('menusel', 'OPEN', 'folderAction',1);
            var enbled = false;
            if (anyChildrenFolders(treedata) )
                enbled = true;
            m.additem('menusel', 'EXPAND', 'folderAction',2,enbled);
            m.additem('menusel', 'RENAME', 'folderAction',3,true);
            m.build(e.pageX,e.pageY-20);
        }
        if (n.ftype == 1) { // folder
            var m = new devtmenu.menu('body',n);
            m.additem('menusel', 'OPEN', 'folderAction',1);
            var enbled = false;
            if (anyChildrenFolders(treedata) )
                enbled = true;
            m.additem('menusel', 'EXPAND', 'folderAction',2,enbled);
            m.additem('menusel', 'RENAME', 'folderAction',3,true);
            m.build(e.pageX,e.pageY-20);
        }
    }
}

function editnamechange(v,src) {
    var p = src.parentElement;
    var d = p.treedata;
    eval.renameDoc(d.id,v);
}

function folderAction(param, element) {
    if (devt.def(param)) {
        switch (param) {
            case 1:
                //open folder
                folderselect(element.devtsrc);
                break;
            case 2:
                //expand folder
                folderexpand(element.devtsrc);
                break;
            case 3:
                //Rename
                var src = element.devtsrc;
                var list = src.getElementsByTagName('SPAN');
                var options = {input: {size: '5'}};
                devt.tedit(list[0],editnamechange,options);
                break;
        }
    }
}

function displayNode(n,element,parent,level) {
    var ftype = parseInt(n.type.substr(0,1));
    if (!devt.def(treenodestatus[n.id]) ) {
        treenodestatus[n.id] = 0;  //Not expanded.    
    }
    if (ftype >= 0 && ftype <= 1)
    {
        var div = devt.cea('DIV',element);
        div.treedata = n;
        div.ftype = ftype;
        div.devtparent = parent;
        if (parent && devt.def(parent.pathname))
            div.pathname = parent.pathname + "/" + n.title;
        else
            div.pathname = n.title;
        div.setAttribute('did',n.id);
        div.setAttribute('onclick','folderselect(this)');
        div.setAttribute('oncontextmenu','rightClick(this,event)');
        div.className = 'l' + level;
        div.devtlevel = level;
        if (ftype == 1) {
            var img = devt.cea('IMG',div);
            //Any children that are folders
            if (anyChildrenFolders(n)) {
                if (treenodestatus[n.id] == 1) {
                    img.src = '/images/Selected.png';
                    div.devtexpanded = 1;
                }
                else {
                    img.src = '/images/Unselected.png';
                    div.devtexpanded = 0;
                }
                img.setAttribute('onclick','folderexpand(this)');
            }
            else
                img.src = '/images/Blank.png';
            
            var img = devt.cea('IMG',div);
            img.src = '/images/Folder-Blue.png';
        }
        
        if (ftype == 0) {
            var img = devt.cea('IMG',div);
            //Any children that are folders
            if (anyChildrenFolders(n)) {
                if (treenodestatus[n.id] == 1) {
                    img.src = '/images/Selected.png';
                    div.devtexpanded = 1;
                }
                else {
                    img.src = '/images/Unselected.png';
                    div.devtexpanded = 0;
                }
                img.setAttribute('onclick','folderexpand(this)');
                var img = devt.cea('IMG',div);
                img.src = '/images/Room.png';
            }
            else
                img.src = '/images/Blank.png';
        }
        var span = devt.cea('SPAN',div);
        span.innerHTML = n.title;
    }
    if (devt.def(n.children)) {
        if (treenodestatus[n.id] != 0) {
            for (var i = 0; i < n.children.length;i++)
                displayNode(n.children[i],element,div,level+1);
        }
    }
}

function collapseTree() {
    var tre = devt.ge('tree');  
    var lc = devt.ge('leftcolapse');
    var imgs = lc.getElementsByTagName('IMG');

    if (treecollapse) {
        tre.style.flexBasis='300px'
        tre.style.borderWidth='1px;'
        tre.style.padding = '5px';
        imgs[0].src = '/images/Collapse2.png';
        treecollapse = false;
        devt.ge('tree2').style.display='block';
    }
    else {
        tre.style.flexBasis='0px';
        tre.style.borderWidth ='2px;'
        tre.style.padding = '0px';
        imgs[0].src = '/images/UnCollapse2.png';
        treecollapse = true;
        devt.ge('tree2').style.display='none';

    }
}

function displayTree(tree,pid) {
    var p = document.getElementById(pid);
    devt.removeAllChildren(p);
    
    var df = devt.cea('DIV',p);
    df.innerHTML = 'FOLDERS';
    df.id = 'treehd';
    
    var nodes = tree.children;
    for (var i = 0; i < nodes.length;i++) {
        displayNode(nodes[i],p,null,0);   
    }
    //Select the first folder
    var l = p.getElementsByTagName('DIV');
    var treediv = getDidTreeDiv(currentfolderDid);
    if (treediv)
        folderselect(treediv);
    //else
    //if (devt.def(l[2])) { //Skip first title and other div
        //folderselect(l[2]);   
    //}  
}

function removeBackHighlight(n) {
    if (n) {
        var l = n.getElementsByTagName('DIV');
        for (var i=0;i<l.length;i++)
            l[i].style.backgroundColor='';
    }
}

function displayolder(n) {
    var latest = n.parentNode.devtdocid;
    var s = n.parentNode.nextSibling;
    if (devt.def(s.devtexpandversions) && s.devtexpandversions) {
        while (s) {
            if (s.devtnewdocid == latest)
                s.style.display = 'none';
            s.devtexpandversions = false;
            s = s.nextSibling;
        }
    }
    else {
        while (s) {
            if (s.style.display == 'none')
                s.style.display = 'table-row';
            s.devtexpandversions = true;
            s = s.nextSibling;
        }
    }
}

function deleteFile(n) {
    var docid = n.parentNode.parentNode.devtdocid;
    eval.deletedoc(docid);
    eval.getAllDocs();
}

function buildfolderheading(n) {
    var f = devt.ge('currentfolder');
    removeAllChildren(f);
    if (devt.def(n.docpath) ) {
        for(var i = 0; i < n.docpath.length;i++) {
            var spn = devt.cea('SPAN',f);
            spn.innerHTML = n.docpath[i].name;
            spn.devtFolder = n.docpath[i].id;
            spn.className='selfolder';
            devt.sa(spn,'onclick','folderselectbyid(this)');
            var s = devt.cea('SPAN',f);
            s.innerHTML = " / ";
        }
    }
}

function buildDetailList(did) {
    
    if (!did)
        did = getFirstNode();
    var d = getDidNode(g_tree,did);
    if (!d) {
        d = getFirstNode();
        currentfolderDid = d.id;
        buildfolderheading(d);
        //devt.ge('currentfolder').innerHTML = d.fullpath;
    }
    
    if (d) {
        var tbl = devt.ge('filetable');
        buildfolderheading(d);
        //devt.ge('currentfolder').innerHTML = d.fullpath;
        removeAllChildren(tbl);
        var TR = devt.cea('TR',tbl);
        TR.innerHTML = "<th colspan='3' class='l'>NAME</th><th class='l'>DESCRIPTION</th><th class='r'>DATE</th><th class='r'>SIZE</th><th class='r'>VERSION</th><th></th>";
        c = d.children;
        var lasttitle = '';
        var newdocid = 0;
        
        //Build the directorup icon
        TR = devt.cea('TR',tbl);
        var td = devt.cea('TD',TR);
        td.className = 'td1';
        var img = devt.cea('IMG',td);
        img.src = '/images/DirUpBlue.png';
        img.setAttribute("onclick","folderselectparent()");
        img.setAttribute("title","Parent Directory");
        td = devt.cea('TD',TR);
        td.setAttribute('colspan','8');
        
        for (var i = 0; i< c.length; i++) {
            var n = c[i];
            var hide = false;
            var nextissamename = false;
            //Check that this is not subsequent version
            if (lasttitle == n.title)
            {
                hide = true;    
            }
            else
            {
                newdocid = n.id;
                if ((i+1) < c.length)
                {
                    //we have another one
                    if (c[i+1].title == n.title)
                        nextissamename= true;
                }
            }
            lasttitle = n.title;
            
            
            TR = devt.cea('TR',tbl);
            if (hide)
            {
                TR.style.display='none';
                TR.devtnewdocid = newdocid;
            }
            TR.devtdocid = n.id;
            
            //Col 0
            var td = devt.cea('TD',TR);
            td.className = 'td1';
            if (n.type.substr(0,1) == '1') {
                var img = devt.cea('IMG',td);
                img.src = '/images/Folder-Blue.png';
            }
            if (n.type.substr(0,1) == '0') {
                var img = devt.cea('IMG',td);
                img.src = '/images/Room.png';
            }
            if (n.type.substr(0,1) == '2') {
                var img = devt.cea('IMG',td);
                img.src = '/images/Document-Blue.png';
            }
        
            //Col 1
            td = devt.cea('TD',TR);
            td.className = 'td1';
            if (nextissamename)
            {
                td.innerHTML = ">";
                td.setAttribute("title","Select for older versions");
                td.setAttribute("onclick","displayolder(this)");
                td.style.cursor = "pointer";
            }
            
            //Col 2
            td = devt.cea('TD',TR);
            if (n.type.substr(0,1) == '2') {
                var a = devt.cea('A',td);
                a.innerHTML = n.title;
                a.href='getFile.php?v=' + n.u;
                a.setAttribute("target","_blank");
                var strTitle = "Uploaded by " + n.cr;
                if (nextissamename)
                    strTitle += " Older versions of this file available";    
                a.setAttribute("title",strTitle);
            }
            else
                td.innerHTML = n.title;
            if (n.type.substr(0,1) == '1') {
                td.className='tdfolder';
                td.setAttribute("title","Created by " + n.cr);
                td.setAttribute("onclick","folderclick(" + n.id  +")");
            }
        
            //Col 3
            td = devt.cea('TD',TR);
            td.className='l';
            if (devt.def(n.desc)) {
                td.innerHTML= n.desc;
            }
            //Col 4
            td = devt.cea('TD',TR);
            td.className='r';
            var dt = new Date(n.ts*1000);
            td.innerHTML = dt.getDate() + "/" + (dt.getMonth() +1) + "/" + dt.getFullYear() + " " + devt.pad(dt.getHours(),2) + ":" + devt.pad(dt.getMinutes(),2) + ":" + devt.pad(dt.getSeconds(),2);
        
            //Col 5
            td = devt.cea('TD',TR);
            td.className='r';
            if (n.type.substr(0,1) == '2')
                td.innerHTML = smartSize(n.size);
            
            //Col 6
            td = devt.cea('TD',TR);
            td.className='r';
            if (n.type.substr(0,1) == '2')
                td.innerHTML = n.version;
            
            //Col 8
            td = devt.cea('TD',TR);
            if (g_candelete) {
                var img = devt.cea('IMG',td);
                img.src = '/images/Delete.png';
                img.setAttribute("onclick","deleteFile(this)");
                img.style.cursor = "pointer";
            }
            
        }
    }
}

function folderselectbyid(n) {
    var d = getDidNode(g_tree,n.devtFolder);
    folderselectbynode(d);
}

function folderselectbynode(n) {
    if (n)
    {
        currentfolderDid = parseInt(n.id);
        buildfolderheading(n);
        buildDetailList(n.id);
    }

}
function folderselect(n) {
    var d = n.treedata;
    if (d)
    {
        folderselectbynode(d);
        removeBackHighlight(n.parentElement);
        n.style.backgroundColor='#eee';
    }
}

function folderselectparent(n) {
    treediv = getDidTreeDiv(currentfolderDid);
    if (treediv) {
        var d = getDidNode(g_tree,currentfolderDid);
        if (d.p) {
            var parentId = d.p;
            var div = getDidTreeDiv(parentId);
            if (div)
                folderselect(div);
        }
    }
    else
    {
        var n = getDidNode(g_tree,currentfolderDid);
        if (n.p) {
            var p = n.p;
            currentfolderDid = p;

            var newn = getDidNode(g_tree,currentfolderDid);
            buildfolderheading(newn);
            //devt.ge('currentfolder').innerHTML = newn.fullpath;
            buildDetailList(p);
        }
    }
}

function folderclick(did) {
    //Find the tree data
    console.log("folderclick did = " + did);
    if (g_tree)
    {
        var n = getDidNode(g_tree,did);
        if (n) {
            currentfolderDid = parseInt(did);
            buildfolderheading(n);
            devt.ge('currentfolder').innerHTML = n.fullpath;
            buildDetailList(did);
        }
    }
    var div = getDidTreeDiv(did);
    if (div)
        folderselect(div);
}

function folderexpand(n) {
    var div = n;
    var img = n;
    if (n.nodeName == 'IMG')
        div = n.parentElement;
    else
        img = div.firstChild;
    var d = div.treedata;
    var t = devt.ge('tree');
    if (!div.devtexpanded) {
        for (var i = 0; i < d.children.length;i++) {
            if (!devt.def(treenodestatus[d.children[i].id]) || treenodestatus[d.children[i].id] == 0) {
                //displayNode(d.children[i],t,div,div.devtlevel+1);
                treenodestatus[d.id] = 1;
            }
        }
        img.src = '/images/Selected.png';
        div.devtexpanded = true;
    }
    else {
        //Renove all divs with parents of n
        var myparent = div.parentElement;
        var list = myparent.children;
        for (var i = 0; i < list.length;i++) {
            if (devt.def(list[i].devtparent) && list[i].devtparent == div) {
                treenodestatus[list[i].treedata.id] = 0;
                list[i].parentElement.removeChild(list[i]);    
                img.src = '/images/Unselected.png';
                div.devtexpanded = false;
                treenodestatus[div.treedata.id] = 0;
            }
        }
    }
    displayTree(g_tree,'tree2');
}

function sizeScreen() {
    var b = document.getElementsByTagName('BODY') [0];
    var w = b.offsetWidth -45;
    var lw = Math.min(150,w);
    var rw = Math.max(w-lw,0);
    //devt.ge('tree').style.width = '300px';
    //devt.ge('detail').style.width = '100%';
}

function allowDrop(e) {
    e.preventDefault();
}

function uploadDroped() {
    var fl = devt.ge('filelist2');
    if (filelist.length > 0)
    {
        //find first not error
        i = -1;
        for (var j = 0; j < filelist.length; j++) {
            if (!devt.def(filelist[j].loaderror) && !filelist[j].loaderror)
                i = j;
        }

        if (i >= 0) {
            var fm = new FormData();
            fm.append('fileidx', filelist[i].devtidx);
            fm.append('parent', currentfolderDid);
            fm.append('file', filelist[i]);
            fm.append('formtoken', g_formtoken);

            //Find the description
            var inplist = fl.getElementsByTagName('INPUT');
            for (var j = 0; j < inplist.length; j++) {
                if (inplist[j].devtidx == filelist[i].devtidx)
                    fm.append('description', inplist[j].value);
            }

            fetch('Upload.php', {
                method: 'POST',
                body: fm
            })
                .then(function (response) {
                    console.log("Fetch Response 1");
                    return response.json();
                }
                )
                .catch(function (error) {
                    console.log("Fetch Error 1");
                }
                )
                .then(function (myjson) {
                    var idx = parseInt(myjson.idx);
                    if (myjson.status == "OK") {
                        //Find in filelist
                        for (var i = 0; i < filelist.length; i++) {
                            if (filelist[i].devtidx == idx) {
                                if (filelist[i].devttr) {
                                    fl.removeChild(filelist[i].devttr);
                                    filelist.splice(i, 1);
                                }
                            }
                        }
                        if (filelist.length == 0) {
                            eval.getAllDocs();
                            hideUpload();
                        }
                        else {
                            uploadDroped();
                        }
                    }
                    else {
                        markFileError(idx, myjson.error);
                    }
                }
                );
        }
    }
    
    var fo = devt.ge('fo');
    var fop = fo.parentElement;
    fop.removeChild(fo);
    fo = devt.cea('INPUT',fop);
    fo.id = 'fo';
    fo.type = 'file';
    fo.setAttribute('onchange','inputfilechange(this)');
    fo.setAttribute('multiple','');
    
}

function uploaddelete(n) {
    var cnt = 0;
    var idx = n.devtidx;
    //Remove from display list
    var fl = devt.ge('filelist2');
    for (i = 0; i < filelist.length; i++) {
        if (filelist[i].devtidx == idx) {
            fl.removeChild(filelist[i].devttr);
            filelist.splice(cnt,1)
            break;
        }
        cnt++;
    }
    filecnt--;
}

function markFileError(idx,errtext) {
    var fl = devt.ge('filelist2');
    for (i = 0; i < filelist.length; i++) {
        if (filelist[i].devtidx == idx) {
            filelist[i].loaderror = true;
            var tr = filelist[i].devttr;
            var cols = tr.getElementsByTagName("TD");
            cols[0].className = 'uploaderror';
            var msg = devt.cea("TD", tr);
            msg.className = 'err';
            var txt = "UPLOAD ERROR: ";
            if (devt.def(errtext))
                txt = txt + errtext;
            msg.innerHTML = txt;
        }
    }
}

    function dropit(e) {
    var fo = devt.ge('fo');
    var fm = devt.ge('fileform');
    var fl = devt.ge('filelist2');
    e.preventDefault();
    var files = e.dataTransfer.files
    for (var i = 0; i < files.length;i++) {
        if (files[i].size < g_maxfilesize) {
            var tr = devt.cea("TR",fl);
            tr.devtidx = filecnt;
            var td = devt.cea("TD",tr);
            td.innerHTML = files[i].name;
        
            //col 1
            var td = devt.cea("TD",tr);
            var inpt=devt.cea("INPUT",td);
            inpt.setAttribute('placeholder','Enter a description (optional)');
            inpt.setAttribute('type','text');
            inpt.setAttribute('name','descrption');
            inpt.setAttribute('size','60');
        
            td = devt.cea("TD",tr);
            td.innerHTML = smartSize(files[i].size);
            files[i].devttr = tr;
            files[i].devtidx = filecnt;
            inpt.devtidx = files[i].devtidx;
        
            td = devt.cea("TD",tr);
            img = devt.cea("IMG",td);
            img.src = "/images/Delete.png";
            img.devtidx = filecnt;
            img.setAttribute('onclick','uploaddelete(this)');
        
            filelist.push(files[i]);
            filecnt++;
        }
        else {
            //File is too big
            var tr = devt.cea("TR",fl);
                
            //col 0
            var td = devt.cea("TD",tr);
            td.innerHTML = files[i].name;
                
            //col 1
            var td = devt.cea("TD",tr);
            td.innerHTML = "Unable to load as file size is too big";
            td.className = td.className + ' err';
            td.className = td.className.trim();    
            
            //col 2
            td = devt.cea("TD",tr);
            td.className='r';
            td.innerHTML = smartSize(files[i].size);
        }
    }
}

function shownewdir() {
    devt.ge('newdirparent').value = currentfolderDid;
    devt.ge('folderdetail').style.display = 'none';
    devt.ge('uploads').style.display = 'none';
    devt.ge('newdir').style.display = 'block';
}

function showuploads() {
    devt.ge('folderdetail').style.display = 'none';
    devt.ge('uploads').style.display = 'block';
    devt.ge('newdir').style.display = 'none';
}

function hideUpload() {
    devt.ge('folderdetail').style.display = 'block';
    devt.ge('uploads').style.display = 'none';
    devt.ge('newdir').style.display = 'none';
}

function cancelUpload() {
    filelist = [];
    devt.removeAllChildren(devt.ge('filelist2'));
    hideUpload();
}

function inputfilechange(n) {
    if (devt.def(n.files)) {
        var fl = devt.ge('filelist2');
        var files=n.files;
        for (var i = 0; i < files.length;i++) {
            if (files[i].size < g_maxfilesize) {
                var tr = devt.cea("TR",fl);
                tr.devtidx = filecnt;
                //col 0
                var td = devt.cea("TD",tr);
                td.innerHTML = files[i].name;
            
                //col 1
                var td = devt.cea("TD",tr);
                var inpt=devt.cea("INPUT",td);
                inpt.setAttribute('placeholder','Enter a description (optional)');
                inpt.setAttribute('type','text');
                inpt.setAttribute('name','descrption');
                inpt.setAttribute('size','60');
            
                td = devt.cea("TD",tr);
                td.className='r';
                td.innerHTML = smartSize(files[i].size);
                files[i].devttr = tr;
                files[i].devtidx = filecnt;
            
                td = devt.cea("TD",tr);
                img = devt.cea("IMG",td);
                img.src = "/images/Delete.png";
                img.devtidx = filecnt;
                img.setAttribute('onclick','uploaddelete(this)');
        
            
                inpt.devtidx = files[i].devtidx;
            
                filelist.push(files[i]);
                filecnt++;
            }
            else {
                //File is too big
                var tr = devt.cea("TR",fl);
                
                //col 0
                var td = devt.cea("TD",tr);
                td.innerHTML = files[i].name;
                
                //col 1
                var td = devt.cea("TD",tr);
                td.innerHTML = "Unable to load as file size is too big";
                td.className = td.className + ' err';
                td.className = td.className.trim();    

                //col 2
                td = devt.cea("TD",tr);
                td.className='r';
                td.innerHTML = smartSize(files[i].size);
            }
        }
    }
}

function tick() {
    eval.getAllDocs();
}

function start() {
    sizeScreen();
    eval.getAllDocs();
    setInterval(tick, 300000);
}
</script>
</head>
<body id='body' onload="start()" onresize="sizeScreen()">
    <div id='container'>
        <div id='heading'>
            <table>
                <td></td>
                <td class='ht'>nValuate - Data Room</td>
                <td></td>
            </table>            
        </div>
        <div id='menu'>
            <?php 
                if (CheckSecurity(SECURITY_ADMIN))
                    echo "<div class='d1'><a href='Admin.php'>ADMIN</a></div>";
                if (IS_MODULE_SCORE() && CheckSecurity(SECURITY_EVALUATE))
                    echo "<div class='d1'><a href='Score'>SCORE</a></div>";
            ?>
            <div class='d1 sel'>DATAROOM</div>
            <div class='d2' onmouseover='eval.dropmenu(this,1)' onmouseout='eval.dropmenu(this,0)'><div><a href='Me.php'><?php if ($user) echo $user['user_name'];?></a></div><div class='d3'><a href='ChangePW.php'>Change Password</a></div><div class='d3'><a href='Signout.php'>Sign Out</a></div></div>
            <div style='clear: left;'></div>
        </div>
        <?php 
            if (!$anydocs)
            {
                echo "<div id='nodocs'>";
                echo "<p class='pmsg1'>You have not been given any access to Data Room documents, please contact you administrator</p>";
                echo "</div>";
            }
        ?>
        <div id='dataroom'>
            <div id='tree'>
                <div id="leftcolapse"><img src="/images/Collapse2.png" onclick="collapseTree(true)"></div>
                <div id='tree2'>
                    <div id='treehd'>FOLDERS</div>
                </div>
            </div>
            <div id='detail'>
                <h1 id='currentfolder'></h1>
                <div id='foldermenu'>
                    <div id='foldermenubar'>
                        <img src='/images/DirUp.png'/ onclick='folderselectparent()' title='Parent Directory'>
                        <img src='/images/NewDir.png' onclick='shownewdir()' title='Create New Directory'/></a>
                        <?php
                        if (CheckSecurity(SECURITY_DATAROOM_LOAD))
                            echo "<button onclick='showuploads()'>UPLOAD FILES</button>"
                        ?>
                    </div>
                </div>
                <div id='folderdetail'>
                    <div id='foldertable'>
                        <table id='filetable'>
                        </table>
                    </div>
                </div>
                <div id='newdir'>
                    <h1>NEW DIRECTORY</h1>
                    <div id='newdirform'>
                        <form method="post" action="<?php echo $selff;?>">
                            <p>ENTER DIRECTORY NAME</p>
                            <input type='text' size='10' name='newdir' /><br/>
                            <input id='newdirparent' type='hidden' name='current' value=''/>
                            <input type='submit' name='NEWDIRBUT' value='CREATE'/>
                            <button onclick='hideUpload()'>CANCEL</button>
                        </form>
                    </div>
                </div>
                <div id='uploads'>
                    <h1>FILE UPLOADS</h1>
                    <div id='uploadform'>
                        <form id='fileform' method="post" enctype='multipart/form-data' action="<?php echo $selff;?>">
                            <input id='fo' type='file' onchange='inputfilechange(this)' multiple/>
                        </form>
                    </div>
                    <div id='dropzone' ondragover="allowDrop(event)" ondrop="dropit(event)" >
                        <img src='/images/Dropzone2.png' alt='Drop Files Here' title='Drag your files and drop them here' />
                    </div>
                    <div id='loadlist'>
                        <h2>UPLOAD LIST</h2>
                        <table id='filelist2'>
                        </table>
                    </div>
                    <button onclick='uploadDroped()'>UPLOAD</button><button onclick='cancelUpload()'>CANCEL</button>
                </div>
            </div>
        </div>
    </div>
</body>
</html>